% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n_obs_x.R
\name{n_obs_x}
\alias{n_obs_x}
\title{Number of valid (i.e. non-missing) observations for column/variable x}
\usage{
n_obs_x(df, by, x, svy = NULL)
}
\arguments{
\item{df}{(data frame) Data to analyse with lowercase column names.}

\item{by}{(string vector) Variable(s) used for tabulating the variable of interest}

\item{x}{(string) Variable of interest for which to compute the number of valid (i.e. non-missing) observations}

\item{svy}{(string) Survey settings that must be equal to one of the following: ALL, IALS, ICCS, ICILS, IELS,
PBTS, PIAAC, PIRLS, PISA, PISAOOS, PISA2015, SSES, SSES2023, SVY, TALISSCH, TALISTCH, TALISEC_LEADER, TALISEC_STAFF, TIMSS}
}
\value{
Data frame containing the number of valid (i.e. non-missing) observations for the variable of interest
}
\description{
Computes the number of valid (i.e. non-missing) observations for the column/variable of interest.
}
\examples{
n_obs_x(df = df_pisa18, by = "cnt",x = "wb173q03ha", svy = "PISA2015")
n_obs_x(df = df_talis18, by = "cntry",x = "tt3g01", svy = "TALISTCH")
}
