% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linter.R
\name{module_namespace_linter}
\alias{module_namespace_linter}
\title{Require usage of \code{ns()} in \code{inputId} and \code{outputId} arguments of UI functions
in \code{{shiny}} modules}
\usage{
module_namespace_linter(
  io_funs = default_shiny_io_functions,
  io_args = c("inputId", "outputId"),
  ns_funs = c("ns", "NS")
)
}
\arguments{
\item{io_funs}{\emph{character}, \code{{shiny}} input/output UI functions to check.
Defaults to \link{default_shiny_io_functions}, which covers all native ones and
several others from \code{{plotly}} or \code{{DT}}. The functions must include the
namespace, i.e., \code{shiny::textInput}.}

\item{io_args}{\emph{character}, arguments of UI functions to check. \code{inputId} and
\code{outputId} by default. These are checked even if unnamed. Named arguments
that partially match are ignored and discouraged.}

\item{ns_funs}{\emph{character}, function names that are considered valid in order
to "namespace" inputs' or outputs' IDs. Defaults to both \code{ns} and \code{NS}
(although we recommend to stick with the former, which is predefined in the
module template).}
}
\value{
A \code{linter} closure. To be used by \code{{lintr}} only. See the first
example below.
}
\description{
A custom \emph{linter} to be used by \code{{lintr}} package. Checks the functions in a
module's UI part for any missing \code{ns()} calls. These are often omitted when
working with the plain \code{{shiny}} or SIA modules. More details follows below.
}
\details{
\subsection{How to use this linter}{

The easiest way is to call \code{\link[=lint_ns]{lint_ns()}} which is essentially a wrapper around:

\if{html}{\out{<div class="sourceCode">}}\preformatted{lintr::lint_package(linters = module_namespace_linter())
}\if{html}{\out{</div>}}

Both calls use our linter for the whole package. However, note that \emph{only}
\code{module_namespace_linter} is considered. Using this custom linter with the
native ones is somewhat complicated, but not impossible. To the best of our
knowledge, the only place where the \code{{lintr}} documentation mentions the
actual usage of external linters, is in
\link[lintr:linters_with_tags]{linters_with_tags()} help page. According to that,
you can pass the following call to \code{linters} argument in any supported
\verb{lintr::lint_*} function:

\if{html}{\out{<div class="sourceCode">}}\preformatted{lintr::linters_with_tags(
 tags = NULL, packages = c("lintr", "SIAtools")
)
}\if{html}{\out{</div>}}

That should select all linters available in both packages.

It is also possible to set up a configuration file that enables you to
shorten calls to \code{{lintr}} functions, use RStudio Addins to lint an active
file, or even apply linters during continuous integration workflows, e.g., in
GitHub Actions or in Travis. To opt for that, create \code{.lintr} file at your
package's root and fill in the following line:

\if{html}{\out{<div class="sourceCode">}}\preformatted{linters: linters_with_tags(tags = NULL, packages = "SIAtools")
}\if{html}{\out{</div>}}

Then, you can use the provided addins or call \code{lintr::lint_package()} to get
your modules checked.
}

\subsection{What the linter does}{

By default, the linter looks for any \code{inputId} or \code{outputId} arguments of
\code{{shiny}}'s UI functions (such as \link[shiny:numericInput]{numericInput} or
\link[shiny:plotOutput]{plotOutput}, respectively), and tests if the values
assigned to the arguments are all "namespaced", i.e., wrapped in \code{ns()}
function. This is crucial for inputs and outputs in the UI portion of a
module to match their counterparts in the server logic chunk.

Only \code{{shiny}} UI calls that are inside of a \link[shiny:reexports]{tagList} in a
function ("lambda" shorthand, \verb{\\( )}, applies as well) are inspected. This is
because we don't want to cause false alarms for any "ordinary" \code{{shiny}} apps
that aren't modules. All UI portions of modules are usually defined as
functions, and all input/output UI functions are inside a
\link[shiny:reexports]{tagList}, so we opted for the this strategy to minimalize
false positive matches outside \code{{shiny}} modules.

We look for any \code{inputId} or \code{outputId} arguments that are named as such. On
top of that, the \code{ns()} omission is detected even if you call the function
without named arguments that would be evaluated as input or output IDs.
However, if you use partial matching (\code{numericInput(inp = "input")}), the
actual input won't get linted, even though it should, as it is eventually
evaluated as \code{inputId}. The same applies for arguments defined outside the
call and passed as a variable, e.g., \verb{inp <- "input"; numericInput(inputId = inp)}. That is tricky to catch in a static code analysis, which is employed
in this linter.
}
}
\examples{
\dontshow{if (requireNamespace("lintr", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# will produce lints
lintr::lint(
  text =
    "module_ui <- function(id, imports, ...) {
      tagList(
        numericInput(inputId = \"input_id_without_ns\", ...)
      )
    }",
  linter = module_namespace_linter()
)

# is OK
lintr::lint(
  text =
    "module_ui <- function(id, imports, ...) {
      tagList(
        numericInput(inputId = ns(\"input_id_with_ns\"), ...)
      )
    }",
  linter = module_namespace_linter()
)
\dontshow{\}) # examplesIf}
}
\seealso{
\link[lintr:linters]{linters} for a complete list of linters available
in lintr.

Other linter-related functions:
\code{\link{lint_ns}()}
}
\concept{linters}
