% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssn_import_predpts.R
\name{ssn_import_predpts}
\alias{ssn_import_predpts}
\title{Import prediction points into an SSN, ssn_lm, or ssn_glm object}
\usage{
ssn_import_predpts(x, predpts, overwrite = FALSE, verbose = TRUE)
}
\arguments{
\item{x}{An object of class\code{SSN}, \code{ssn_lm}, or
\code{ssn_glm}.}

\item{predpts}{Name of the prediction point dataset to import in
character format. See details.}

\item{overwrite}{default = \code{FALSE}. If \code{TRUE}, overwrite
existing netgeom column(s) if they exist in the
prediction site dataset.}

\item{verbose}{default = \code{TRUE}. If \code{FALSE}, warning messages will not be printed to the console.}
}
\value{
an object of class \code{SSN}, \code{ssn_lm}, or
\code{ssn_glm} which contains the new prediction dataset.
}
\description{
A shapefile of prediction points found in the .ssn
directory are imported into an existing object of class
\code{SSN}, \code{ssn_lm}, or \code{ssn_glm}.
}
\details{
\command{ssn_import_predpts} imports one set of prediction
points residing in the .ssn directory into an existing
\code{SSN}, \code{ssn_lm}, or \code{ssn_glm} object. The
prediction dataset must be in shapefile or geopackage format
(.shp or .gpkg, respectively) and reside in the ssn.object$path
directory. The path for an \code{SSN} object can be updated using
\command{ssn_update_path()} prior to importing prediction
datasets. The argument \code{predpts} accepts the name of the
prediction point dataset, with or without the file extension. If
it is passed as a named vector (of length 1), then the name
provided is used as the prediction dataset name in the \code{SSN}
object prediction sites list
(e.g. \code{names(ssn.obj$preds)}). Otherwise, the file basename
is used in the names attribute. See
\code{\link[SSN2]{ssn_import}} for a detailed description of the
prediction dataset format within the \code{SSN} class object.

When the prediction dataset is imported, a new column named
\code{netgeom} is created. If this column already exists it is
overwritten. Please see \code{\link{create_netgeom}} for a
detailed description of the \code{netgeom} column and the
information it contains.

The prediction dataset specified in \code{predpts} must contain the
spatial, topological and attribute information needed to make
predictions using an ssn_lm or ssn_glm object. This information
is generated using the \code{SSNbler} package, which makes use of
the functionality found in the \code{sf} and \code{igraph}
packages to process streams data in vector format.
}
\examples{
## Create local temporary copy of MiddleFork04.ssn found in
# SSN2/lsndata folder. Only necessary for this example.
copy_lsn_to_temp()

## Import SSN object with no prediction sites
mf04p <- ssn_import(paste0(tempdir(), "/MiddleFork04.ssn"),
  overwrite = TRUE
)

## Import pred1km prediction dataset into SSN object and assign the
## name preds1
mf04p <- ssn_import(paste0(tempdir(), "/MiddleFork04.ssn"),
    overwrite = TRUE)
mf04p <- ssn_import_predpts(mf04p, predpts = c(preds1 = "pred1km"))
names(mf04p$preds)

## Import CapeHorn prediction dataset into a ssn_glm object, using
## the default file basename as the name
ssn_gmod <- ssn_glm(Summer_mn ~ netID, mf04p,
  family = "Gamma",
  tailup_type = "exponential", additive = "afvArea"
)
ssn_gmod <- ssn_import_predpts(ssn_gmod, predpts = "CapeHorn")
names(ssn_gmod$ssn.object$preds)

}
