% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCORI_fulldata_model.R,
%   R/PCORI_within_group_model.R
\name{fit_SensIAT_fulldata_model}
\alias{fit_SensIAT_fulldata_model}
\alias{fit_SensIAT_within_group_model}
\title{Produce fitted model for group (treatment or control)}
\usage{
fit_SensIAT_fulldata_model(data, trt, ...)

fit_SensIAT_within_group_model(
  group.data,
  outcome_modeler,
  knots,
  id.var,
  outcome.var,
  time.var,
  alpha = 0,
  intensity.covariates = ~.,
  outcome.covariates = ~. - 1,
  End = max({
     {
         time.var
     }
 }, na.rm = TRUE) + 1,
  integration.tolerance = .Machine$double.eps^(1/3),
  intensity.bandwidth = NULL,
  ...,
  influence.args = list()
)
}
\arguments{
\item{data}{the full data set.}

\item{trt}{an expression that determine what is treated as the treatment.
Everything not treatment is considered control.}

\item{...}{add parameters as needed or use this to pass forward into the
outcome_modeler.}

\item{group.data}{The data for the group that is being analyzed.
Preferably passed in as a single \code{tibble} that internally is
subsetted/filtered as needed.}

\item{outcome_modeler}{A separate function that may be swapped out to switch
between negative-binomial, single index model, or another we will
dream up in the future.}

\item{knots}{knot locations for defining the spline basis.}

\item{id.var}{The variable that identifies the patient.}

\item{outcome.var}{The variable that contains the outcome.}

\item{time.var}{The variable that contains the time.}

\item{alpha}{The sensitivity parameter.}

\item{intensity.covariates}{A formula representing modifications to the intensity model.}

\item{outcome.covariates}{A formula representing modifications to the outcome model.  The default removes the intercept term.}

\item{End}{The end time for this data analysis, we need to set the default value as the
max value of the time}

\item{integration.tolerance}{The tolerance for the integration.}

\item{intensity.bandwidth}{The bandwidth for the intensity model kernel.}

\item{influence.args}{A list of additional arguments to pass to the influence function.}
}
\value{
a list with class \code{SensIAT-fulldata-fitted-model} with two components,
\code{control} and \code{treatment}, each of which is an independently fitted
\code{SensIAT-within-group-fitted-model} fit with the fit_within_group_model
function.

Should return everything needed to define the fit of the model.
This can then be used for producing the estimates of mean, variance,
and in turn treatment effect.  For the full data model a list with two
models one each for the treatment and control groups.
}
\description{
Produces a fitted model that may be used to produce estimates of mean and
variance for the given group.
}
\details{
This function should be agnostic to whether it is being provided a
treatment or control group.
}
\section{Functions}{
\itemize{
\item \code{fit_SensIAT_fulldata_model()}: Fit the sensitivity analysis for both treatment and control groups.

}}
\examples{
\donttest{
model <-
    fit_SensIAT_within_group_model(
        group.data = SensIAT_example_data,
        outcome_modeler = SensIAT_sim_outcome_modeler,
        alpha = c(-0.6, -0.3, 0, 0.3, 0.6),
        id.var = Subject_ID,
        outcome.var = Outcome,
        time.var = Time,
        End = 830,
        knots = c(60,60,60,60,260,460,460,460,460),
    )
}
}
