% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process-file.R
\name{process_file}
\alias{process_file}
\title{Process a file to generate normalised data and reports}
\usage{
process_file(
  plate_filepath,
  layout_filepath,
  output_dir = "normalised_data",
  format = "xPONENT",
  generate_report = FALSE,
  process_plate = TRUE,
  normalisation_types = c("RAU", "nMFI"),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{plate_filepath}{(\code{character(1)}) The path to the plate file.}

\item{layout_filepath}{(\code{character(1)}) The path to the layout file.}

\item{output_dir}{(\code{character(1)}) The directory where the output files should be saved. The default is \code{"normalised_data"}.}

\item{format}{(\code{character(1)}) The format of the Luminex data. The default is \code{"xPONENT"}. Available options are \code{"xPONENT"} and \code{"INTELLIFLEX"}.}

\item{generate_report}{(\code{logical(1)}) If \code{TRUE}, generate a quality control report. The default is \code{FALSE}.}

\item{process_plate}{(\code{logical(1)}) If \code{TRUE}, process the plate. The default is \code{TRUE}.
If the value is set to \code{FALSE} the function will only read the plate file and return the plate object.}

\item{normalisation_types}{(\code{character()}) A vector of normalisation types to use. The default is \code{c("RAU", "nMFI")}.}

\item{verbose}{(\code{logical(1)}) Print additional information. The default is \code{TRUE}.}

\item{...}{Additional arguments to for the \code{read_luminex_data} function.}
}
\description{
Perform \code{process_plate} and \code{generate_plate_report} for a given plate file.
In more detail, this function reads the plate file and calls the \code{process_plate}
on the processed plate objects across all the normalisation types, including the raw MFI values.
If the user has specified the \code{generate_report} flag, it will also call the \code{generate_plate_report} function
generating the quality control report.
}
\examples{

# Select an input csv file for processing and corresponding layout file
plate_file <- system.file("extdata", "CovidOISExPONTENT_CO_reduced.csv", package = "SerolyzeR")
layout_file <- system.file("extdata", "CovidOISExPONTENT_CO_layout.xlsx", package = "SerolyzeR")

example_dir <- tempdir(check = TRUE) # a temporary directory
# create and save dataframe with computed dilutions for all suported noramlization types
process_file(plate_file, layout_file, output_dir = example_dir)

example_dir2 <- tempdir(check = TRUE) # a temporary directory
# process the plate for a specific normalization type
process_file(plate_file, layout_file, output_dir = example_dir2, normalisation_types = c("RAU"))

}
