% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SampleSize.R
\name{derive_varcov_list}
\alias{derive_varcov_list}
\title{Derive Variance-Covariance Matrix List}
\usage{
derive_varcov_list(
  mu_list,
  sigma_list,
  ynames_list = NULL,
  varcov_list = NULL,
  cor_mat = NULL,
  rho = 0
)
}
\arguments{
\item{mu_list}{A list of numeric vectors representing the means (\eqn{\mu}) for each treatment arm. Each element corresponds to one arm.}

\item{sigma_list}{A list of numeric vectors representing the standard deviations (\eqn{\sigma}) for each treatment arm. Each element corresponds to one arm.}

\item{ynames_list}{A list of character vectors specifying the names of the endpoints for each arm. Each element corresponds to one arm.}

\item{varcov_list}{(Optional) A pre-specified list of variance-covariance matrices for each arm. If provided, it will override the construction of variance-covariance matrices.}

\item{cor_mat}{(Optional) A correlation matrix to be used for constructing the variance-covariance matrices when there are multiple endpoints. If dimensions do not match the number of endpoints, a warning is issued.}

\item{rho}{(Optional) A numeric value specifying the constant correlation coefficient to be used between all pairs of endpoints if no correlation matrix is provided. Default is 0 (uncorrelated endpoints).}
}
\value{
A list of variance-covariance matrices, one for each treatment arm.
}
\description{
Constructs a list of variance-covariance matrices for multiple treatment arms based on provided standard deviations,
means, and correlation structures.
}
\details{
This function creates a list of variance-covariance matrices for multiple treatment arms. If the \code{varcov_list} is not provided,
the function uses the \code{sigma_list} to compute the matrices. For single endpoints, the variance is simply the square of the standard deviation.
For multiple endpoints, the function constructs the matrices using either a provided \code{cor_mat} or the constant correlation coefficient \code{rho}.

The function ensures that the lengths of \code{mu_list}, \code{sigma_list}, and \code{ynames_list} match for each arm. If dimensions mismatch,
or if neither a variance-covariance matrix (\code{varcov_list}) nor a standard deviation list (\code{sigma_list}) is provided, an error is raised.
}
\author{
Thomas Debray \email{tdebray@fromdatatowisdom.com}
}
\keyword{internal}
