% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSpatialCoor.R
\name{plotSpatialClustering}
\alias{plotSpatialClustering}
\title{Plot results of clustering based on predicted cell proportions}
\usage{
plotSpatialClustering(
  object,
  index.st,
  method,
  k.nn,
  k.centers,
  colors,
  size.point = 1,
  title = NULL,
  theme = NULL
)
}
\arguments{
\item{object}{A \code{\linkS4class{SpatialDDLS}} object.}

\item{index.st}{Index of the spatial transcriptomics data to be plotted. It
can be either a position or a name if a named list of
\code{\link[SpatialExperiment]{SpatialExperiment}} objects was provided.}

\item{method}{Clustering method results to plot. It can be \code{"graph"} or
\code{"k.means"}. If missing, the first configuration found in the object
will be plotted.}

\item{k.nn}{Number of nearest neighbors used if \code{ method == "graph"}.}

\item{k.centers}{Number of k centers used if \code{ method == "k.means"}.}

\item{colors}{Vector of colors to be used.}

\item{size.point}{Size of points (0.1 by default).}

\item{title}{Title of plot.}

\item{theme}{\pkg{ggplot2} theme.}
}
\value{
A ggplot object.
}
\description{
Color spots on the spatial coordinates according to the results of
clustering based on predicted proportions.
}
\seealso{
\code{\link{spatialPropClustering}} \code{\link{deconvSpatialDDLS}}
}
