% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.R
\name{make}
\alias{make}
\title{Run R Script if Needed}
\usage{
make(recipe, prereq, target, include = TRUE, engine = source,
  details = FALSE, force = FALSE, recon = FALSE, quiet = TRUE, ...)
}
\arguments{
\item{recipe}{script filename.}

\item{prereq}{one or more files required by the script. For example, data
files, scripts, or \code{NULL}.}

\item{target}{one or more output files produced by the script. Directory
names can also be used.}

\item{include}{whether to automatically include the script itself as a
prerequisite file. This means that if the script file has been
modified, it should be run.}

\item{engine}{function to source the script.}

\item{details}{whether to show a diagnostic table of files and time last
modified.}

\item{force}{whether to run the R script unconditionally.}

\item{recon}{whether to return \code{TRUE} or \code{FALSE}, without actually
running the R script.}

\item{quiet}{whether to suppress messages.}

\item{\dots}{passed to \code{engine}.}
}
\value{
\code{TRUE} or \code{FALSE}, indicating whether the script was run.
}
\description{
Run an R script if underlying files have changed, otherwise do nothing.
}
\details{
A \code{make()} call has the general form
\preformatted{
make("analysis.R", "input.dat", "output.dat")
}
which can be read aloud as:

\dQuote{script \emph{x} uses \emph{y} to produce \emph{z}}
}
\note{
This function provides functionality similar to makefile rules, to determine
whether a script should be (re)run or not.

If any \code{target} is either missing or is older than any \code{prereq},
then the script is run.
}
\examples{
\dontrun{
# Here, model.R uses input.dat, creating results.dat
make("model.R", "data/input.dat", "model/results.dat")
make("model.R", "data/input.dat", "model/results.dat", quiet=FALSE)
make("model.R", "data/input.dat", "model/results.dat", details=TRUE)
}

}
\references{
Stallman, R. M. \emph{et al}.
An introduction to makefiles.
Chapter 2 in the \emph{\href{https://www.gnu.org/software/make/manual/}{GNU
Make manual}}.
}
\seealso{
\code{\link{source}} runs any R script, \code{\link{source.taf}} is more
convenient for running a TAF script, and \code{\link{source.all}} runs all
TAF scripts.

\code{\link{make}}, \code{\link{make.taf}}, and \code{\link{make.all}} are
similar to the \code{source} functions, except they avoid repeating tasks
that have already been run.

\code{\link{TAF-package}} gives an overview of the package.

The \pkg{makeit} package provides a similar \code{make} function, along with
a vignette containing annotated examples and a discussion.
}
