% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_plot.R
\name{survival_plot}
\alias{survival_plot}
\title{Survival plot for analyzing and visualizing survival data.}
\usage{
survival_plot(
  data,
  curve_function = "pct",
  conf_inter = TRUE,
  interval_style = "ribbon",
  risk_table = TRUE,
  num_censor = TRUE,
  sci_palette = "aaas",
  ggTheme = "theme_light",
  x_start = 0,
  y_start = 0,
  y_end = 100,
  x_break = 10,
  y_break = 10
)
}
\arguments{
\item{data}{Dataframe: survival record data (1st-col: Time, 2nd-col: Status, 3rd-col: Group).}

\item{curve_function}{Character: an arbitrary function defining a transformation of the survival curve. Often used transformations can be specified with a character argument: "event" plots cumulative events (f(y) = 1-y), "cumhaz" plots the cumulative hazard function (f(y) = -log(y)), and "pct" for survival probability in percentage.}

\item{conf_inter}{Logical: confidence interval. Default: TRUE, options: TRUE, FALSE.}

\item{interval_style}{Character: confidence interval style. Default: "ribbon", options: "ribbon", "step".}

\item{risk_table}{Logical: show cumulative risk table. Default: TRUE, options: TRUE, FALSE.}

\item{num_censor}{Logical: show cumulative number of censoring. Default: TRUE, options: TRUE, FALSE.}

\item{sci_palette}{Character: ggsci color palette. Default: "aaas", options: "aaas", "npg", "lancet", "jco", "ucscgb", "uchicago", "simpsons", "rickandmorty".}

\item{ggTheme}{Character: ggplot2 themes. Default: "theme_light", options: "theme_default", "theme_bw", "theme_gray", "theme_light", "theme_linedraw", "theme_dark", "theme_minimal", "theme_classic", "theme_void"}

\item{x_start}{Numeric: x-axis start value. Default: 0, min: 0, max: null.}

\item{y_start}{Numeric: y-axis start value. Default: 0, min: 0, max: 100.}

\item{y_end}{Numeric: y-axis end value. Default: 100, min: 0, max: 100.}

\item{x_break}{Numeric: x-axis break value. Default: 10, min: 0, max: null.}

\item{y_break}{Numeric: y-axis break value. Default: 10, min: 0, max: 100.}
}
\value{
Plot: survival plot for analyzing and visualizing survival data.
}
\description{
Survival plot for analyzing and visualizing survival data.
}
\examples{
# 1. Library TOmicsVis package
library(TOmicsVis)

# 2. Use example dataset
data(survival_data)
head(survival_data)

# 3. Default parameters
survival_plot(survival_data)

# 4. Set conf_inter = FALSE
survival_plot(survival_data, conf_inter = FALSE)

# 5. Set sci_palette = "jco"
survival_plot(survival_data, sci_palette = "jco")

}
\author{
benben-miao
}
