% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plottprTrees.R
\name{plot.tprTrees}
\alias{plot.tprTrees}
\title{Plot taper curve for an object of class \code{tprTrees}}
\usage{
\method{plot}{tprTrees}(
  x,
  bark = NULL,
  col.bark = NULL,
  obs = FALSE,
  assort = NULL,
  legend = FALSE,
  ...
)
}
\arguments{
\item{x}{an object of class 'tprTrees'}

\item{bark}{either NULL or logical; if TRUE taper curve over bark is plotted,
if FALSE taper curve under bark is plotted; if NULL, both are plotted}

\item{col.bark}{color to be used for plot of bark, if plot of taper curve
over and under bark is requested}

\item{obs}{should observations (measured/observed diameters) be added to
the plot?}

\item{assort}{assortments produced by \code{tprAssortment(, value="merge")}}

\item{legend}{logical, if legend should be added}

\item{...}{further arguments for \code{plot} and \code{points}}
}
\value{
No return value, called for side effects
}
\description{
creating a plot of the taper curve of a tree, over or under bark
}
\details{
plots the taper curve of a tree. Either over bark or under bark, or
both. Elements design can partly be chosen. If assortments are given, these
are added to the plot. Doing that, the assortment bottom and top position is
indicated by a vertical line and mid-diameter is shown as a point with
vertical dashed line. N.B. the mid-diameter shown is under bark and rounded
downwards for 0.5 cm if mid-diameter < 20 and for 0.75 cm if bigger. Volume
is calculated using this diameter. Reason for that behaviour is that
assortment information with regard to diameter and volume reflects the legal
rules for roundwood assortments (german RVR).
Additionally, assortment names are indicated.
One can provide assortment names in a column of \code{assort} named
'assortname', which will be used if available, otherwise the 'Sort'-column
 will be used. See Examples.
}
\examples{
## plotting the taper curve of a tree
oldpar <- par()
par(mfrow = c(1, 1))
tree <- tprTrees(spp=1L, Dm=40, Hm=1.3, H=35)
plot(tree, type = "l", las = 1, legend = TRUE)
plot(tree, bark = TRUE, las = 1)
plot(tree, bark = FALSE, las = 1, obs=TRUE) # obs incl. bark!!!
tree <- tprTrees(spp=c(1, 1), Dm = c(40, 35), Hm=c(1.3, 1.3), H = c(35, 30))
plot(tree, bark = FALSE, las = 1, legend = TRUE) # both trees are plotted
plot(tree, bark = TRUE, las = 1, legend = TRUE, obs=TRUE)

tree <- tprTrees(spp=1L, Dm=c(40, 32), Hm=c(1.3, 10.5), H=35)
plot(tree, type = "l", las = 1, legend = TRUE, obs=TRUE)

## if monotonicity is not forced:
tree <- tprTrees(spp=3L, Dm=8, Hm=1.3, H=10)
plot(tree, type = "l", las = 1, obs=TRUE, mono=FALSE)
plot(tree, type = "l", las = 1, obs=TRUE, mono=TRUE) # default

tree <- tprTrees(spp=c(1, 8), Dm = c(40, 40), Hm=c(1.3, 1.3), H = c(35, 35))
plot(tree, bark = NULL, las = 1, col.bark = "blue", legend = TRUE)
plot(tree, bark = NULL, las = 1, col.bark = "blue", legend = TRUE, obs = TRUE)
plot(tree[1, ], main = tprSpeciesCode(spp(tree[1, ]), out = "long"))
plot(tree[2, ], main = tprSpeciesCode(spp(tree[2, ]), out = "scientific"))
par(mfrow = c(1, 2))
plot(tree, bark = TRUE, las = 1)

## now add assortments into taper curve
par(mfrow = c(1, 1))
pars <- parSort(n=length(tree), Lxh=1, fixN=2, fixL=4, fixA=10)
ass <- tprAssortment(tree, pars=pars)
plot(tree, assort = ass)
plot(tree, bark = FALSE, assort = ass)
plot(tree, bark = FALSE, assort = ass, legend = TRUE)
plot(tree[1, ], assort = ass[ass$tree == 1, ], main = "first tree in subset")
plot(tree[2, ], assort = ass[ass$tree == 2, ], main = "second tree in subset")

## adding own assortment labels using column 'assortname'
ass$assortname <- ifelse(grepl("fix", ass$sort), paste0("Fix:", ass$length), ass$sort)
plot(tree, assort = ass)
par(oldpar)
}
