% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07-visualization.R
\name{plot_fishing_zones}
\alias{plot_fishing_zones}
\title{Plot fishing zones}
\usage{
plot_fishing_zones(
  data,
  coastline = NULL,
  parallels = NULL,
  type = "static",
  title = NULL,
  colors = NULL,
  show_legend = FALSE,
  legend_title = NULL,
  zone_labels = NULL,
  add_grid = FALSE,
  base_layers = FALSE,
  minimap = FALSE
)
}
\arguments{
\item{data}{Data frame with fishing zone coordinates and metadata.}

\item{coastline}{Data frame with coastline coordinates (columns "Long" and "Lat").
If NULL, uses internal dataset.}

\item{parallels}{List of data frames with coast-parallel lines.}

\item{type}{Plot type: "static" for ggplot2 or "interactive" for leaflet.}

\item{title}{Plot title.}

\item{colors}{Vector of colors for zones. If NULL, auto-generated.}

\item{show_legend}{Logical. Show legend/layer control.}

\item{legend_title}{Legend title.}

\item{zone_labels}{Vector of custom labels for zones.}

\item{add_grid}{Logical. Add coordinate grid (static only).}

\item{base_layers}{Logical. Include multiple base map layers (interactive only).}

\item{minimap}{Logical. Add minimap (interactive only).}
}
\value{
ggplot object (static) or leaflet object (interactive).
}
\description{
Creates visualizations of fishing zones using either ggplot2 (static) or
leaflet (interactive). This function consolidates all zone plotting functionality.
}
\examples{
\dontrun{
plot_fishing_zones(
  data = zone_data,
  coastline = coastline_data,
  type = "static",
  title = "Fishing Zones",
  show_legend = TRUE
)

plot_fishing_zones(
  data = zone_data,
  coastline = coastline_data,
  type = "interactive",
  base_layers = TRUE,
  minimap = TRUE
)
}

}
