% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{export}
\alias{export}
\title{export}
\usage{
export(
  andromeda,
  outputPath = NULL,
  ageWindow = 10,
  minCellCount = 5,
  censorType = "minCellCount",
  archiveName = NULL,
  nonePaths = FALSE,
  stratify = FALSE
)
}
\arguments{
\item{andromeda}{(\code{Andromeda::andromeda()})
Andromeda object.}

\item{outputPath}{(\code{character}: \code{NULL}) Output path where to write output
files to. When set to \code{NULL} no files will be written, and only the results
object is returned.}

\item{ageWindow}{(\code{integer(n)}: \code{10})\cr
Number of years to bin age groups into. It may also be a vector of integers.
I.e. \code{c(0, 18, 150)} which will results in age group \code{0-18} which includes
subjects \verb{< 19}. And age group \code{18-150} which includes subjects \verb{> 18}.}

\item{minCellCount}{(\code{integer(1)}: \code{5})\cr
Minimum count required per pathway. Censors data below \code{x} as \verb{<x}. This
minimum value will carry over to the sankey diagram and sunburst plot.}

\item{censorType}{(\code{character(1)})\cr
\describe{
\item{\code{"minCellCount"}}{Censors pathways <\code{minCellCount} to \code{minCellCount}.}
\item{\code{"remove"}}{Censors pathways <\code{minCellCount} by removing them completely.}
\item{\code{"mean"}}{Censors pathways <\code{minCellCount} to the mean of all frequencies below \code{minCellCount}}
}}

\item{archiveName}{(\code{character(1)}: \code{NULL})\cr
If not \code{NULL} adds the exported files to a ZIP-file with the specified archive name.}

\item{nonePaths}{(\code{logical(1)}) Should \code{None} paths be included? This will
fetch all persons included in the target cohort and assign them a \code{"None"}
pathway. Significantly impacts performance.}

\item{stratify}{(\code{logical(1)}) Should pathways be stratified? This will
perform pairwise stratification between age, sex, and index year.
Significantly impacts performance.}
}
\value{
\code{TreatmentPatternsResults} object
}
\description{
Export andromeda generated by \link[TreatmentPatterns]{computePathways}
object to sharable csv-files and/or a zip archive.
}
\examples{
\donttest{
ableToRun <- all(
  require("CirceR", character.only = TRUE, quietly = TRUE),
  require("CDMConnector", character.only = TRUE, quietly = TRUE),
  require("TreatmentPatterns", character.only = TRUE, quietly = TRUE),
  require("dplyr", character.only = TRUE, quietly = TRUE)
)

if (ableToRun) {
  library(TreatmentPatterns)
  library(CDMConnector)
  library(dplyr)

  withr::local_envvar(
    R_USER_CACHE_DIR = tempfile(),
    EUNOMIA_DATA_FOLDER = Sys.getenv("EUNOMIA_DATA_FOLDER", unset = tempfile())
  )

  tryCatch({
    if (Sys.getenv("skip_eunomia_download_test") != "TRUE") {
      CDMConnector::downloadEunomiaData(overwrite = TRUE)
    }
  }, error = function(e) NA)

  con <- DBI::dbConnect(duckdb::duckdb(), dbdir = eunomia_dir())
  cdm <- cdmFromCon(con, cdmSchema = "main", writeSchema = "main")

  cohortSet <- readCohortSet(
    path = system.file(package = "TreatmentPatterns", "exampleCohorts")
  )

  cdm <- generateCohortSet(
    cdm = cdm,
    cohortSet = cohortSet,
    name = "cohort_table"
  )

  cohorts <- cohortSet \%>\%
    # Remove 'cohort' and 'json' columns
    select(-"cohort", -"json") \%>\%
    mutate(type = c("event", "event", "event", "event", "exit", "event", "event", "target")) \%>\%
    rename(
      cohortId = "cohort_definition_id",
      cohortName = "cohort_name",
    ) \%>\%
    select("cohortId", "cohortName", "type")

  outputEnv <- computePathways(
    cohorts = cohorts,
    cohortTableName = "cohort_table",
    cdm = cdm
  )

  results <- export(
    andromeda = outputEnv
  )

  Andromeda::close(outputEnv)
  DBI::dbDisconnect(con, shutdown = TRUE)
}
}
}
