% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreatmentPatternsResults.R
\name{TreatmentPatternsResults}
\alias{TreatmentPatternsResults}
\title{TreatmentPatternsResults Class}
\description{
Houses the results of a \code{TreatmentPatterns} analysis. Each field corresponds
to a file. Plotting methods are provided.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{attrition}}{(\code{data.frame})}

\item{\code{metadata}}{(\code{data.frame})}

\item{\code{treatment_pathways}}{(\code{data.frame})}

\item{\code{summary_event_duration}}{(\code{data.frame})}

\item{\code{counts_age}}{(\code{data.frame})}

\item{\code{counts_sex}}{(\code{data.frame})}

\item{\code{counts_year}}{(\code{data.frame})}

\item{\code{cdm_source_info}}{(\code{data.frame})}

\item{\code{analyses}}{(\code{data.frame})}

\item{\code{arguments}}{(\code{list})}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TreatmentPatternsResults-new}{\code{TreatmentPatternsResults$new()}}
\item \href{#method-TreatmentPatternsResults-saveAsZip}{\code{TreatmentPatternsResults$saveAsZip()}}
\item \href{#method-TreatmentPatternsResults-saveAsCsv}{\code{TreatmentPatternsResults$saveAsCsv()}}
\item \href{#method-TreatmentPatternsResults-uploadResultsToDb}{\code{TreatmentPatternsResults$uploadResultsToDb()}}
\item \href{#method-TreatmentPatternsResults-load}{\code{TreatmentPatternsResults$load()}}
\item \href{#method-TreatmentPatternsResults-plotSunburst}{\code{TreatmentPatternsResults$plotSunburst()}}
\item \href{#method-TreatmentPatternsResults-plotSankey}{\code{TreatmentPatternsResults$plotSankey()}}
\item \href{#method-TreatmentPatternsResults-plotEventDuration}{\code{TreatmentPatternsResults$plotEventDuration()}}
\item \href{#method-TreatmentPatternsResults-clone}{\code{TreatmentPatternsResults$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TreatmentPatternsResults-new"></a>}}
\if{latex}{\out{\hypertarget{method-TreatmentPatternsResults-new}{}}}
\subsection{Method \code{new()}}{
Initializer method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreatmentPatternsResults$new(
  attrition = NULL,
  metadata = NULL,
  treatmentPathways = NULL,
  summaryEventDuration = NULL,
  countsAge = NULL,
  countsSex = NULL,
  countsYear = NULL,
  cdmSourceInfo = NULL,
  analyses = NULL,
  arguments = NULL,
  filePath = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{attrition}}{(\code{data.frame}) attrition result.}

\item{\code{metadata}}{(\verb{data.frame)}) metadata result.}

\item{\code{treatmentPathways}}{(\verb{data.frame)}) treatmentPathways result.}

\item{\code{summaryEventDuration}}{(\verb{data.frame)}) summaryEventDuration result.}

\item{\code{countsAge}}{(\verb{data.frame)}) countsAge result.}

\item{\code{countsSex}}{(\verb{data.frame)}) countsSex result.}

\item{\code{countsYear}}{(\verb{data.frame)}) countsYear result.}

\item{\code{cdmSourceInfo}}{(\code{data.frame}) cdmSourceInfo result.}

\item{\code{analyses}}{(\code{data.frame}) Analyses result.}

\item{\code{arguments}}{(\code{list}) Named list of arguments used.}

\item{\code{filePath}}{(\code{character}) File path to either a directory or zip-file, containing the csv-files.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TreatmentPatternsResults-saveAsZip"></a>}}
\if{latex}{\out{\hypertarget{method-TreatmentPatternsResults-saveAsZip}{}}}
\subsection{Method \code{saveAsZip()}}{
Save the results as a zip-file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreatmentPatternsResults$saveAsZip(path, name, verbose = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(\code{character(1)}) Path to write to.}

\item{\code{name}}{(\code{character(1)}) File name.}

\item{\code{verbose}}{(\code{logical}: \code{TRUE}) Verbose messaging.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TreatmentPatternsResults-saveAsCsv"></a>}}
\if{latex}{\out{\hypertarget{method-TreatmentPatternsResults-saveAsCsv}{}}}
\subsection{Method \code{saveAsCsv()}}{
Save the results as csv-files.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreatmentPatternsResults$saveAsCsv(path, verbose = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(\code{character(1)}) Path to write to.}

\item{\code{verbose}}{(\code{logical}: \code{TRUE}) Verbose messaging.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TreatmentPatternsResults-uploadResultsToDb"></a>}}
\if{latex}{\out{\hypertarget{method-TreatmentPatternsResults-uploadResultsToDb}{}}}
\subsection{Method \code{uploadResultsToDb()}}{
Upload results to a resultsDatabase using \code{ResultModelManager}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreatmentPatternsResults$uploadResultsToDb(
  connectionDetails,
  schema,
  prefix = "tp_",
  overwrite = TRUE,
  purgeSiteDataBeforeUploading = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{connectionDetails}}{(\code{ConnectionDetails}) ConnectionDetails object from \code{DatabaseConnector}.}

\item{\code{schema}}{(\code{character(1)}) Schema to write tables to.}

\item{\code{prefix}}{(\code{character(1)}: \code{"tp_"}) Table prefix.}

\item{\code{overwrite}}{(\code{logical(1)}: \code{TRUE}) Should tables be overwritten?}

\item{\code{purgeSiteDataBeforeUploading}}{(\code{logical}: \code{FALSE}) Should site data be purged before uploading?}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TreatmentPatternsResults-load"></a>}}
\if{latex}{\out{\hypertarget{method-TreatmentPatternsResults-load}{}}}
\subsection{Method \code{load()}}{
Load data from files.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreatmentPatternsResults$load(filePath)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filePath}}{(\code{character(1)}) Path to a directory or zip-file containing the result csv-files.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TreatmentPatternsResults-plotSunburst"></a>}}
\if{latex}{\out{\hypertarget{method-TreatmentPatternsResults-plotSunburst}{}}}
\subsection{Method \code{plotSunburst()}}{
Wrapper for \code{TreatmentPatterns::createSunburstPlot()}, but with data filtering step.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreatmentPatternsResults$plotSunburst(
  age = "all",
  sex = "all",
  indexYear = "all",
  nonePaths = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{age}}{(\code{character(1)}) Age group.}

\item{\code{sex}}{(\code{character(1)}) Sex group.}

\item{\code{indexYear}}{(\code{character(1)}) Index year group.}

\item{\code{nonePaths}}{(\code{logical(1)}) Should \code{None} paths be included?}

\item{\code{...}}{Parameters for \code{TreatmentPatterns::createSunburstPlot()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{htmlwidget}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TreatmentPatternsResults-plotSankey"></a>}}
\if{latex}{\out{\hypertarget{method-TreatmentPatternsResults-plotSankey}{}}}
\subsection{Method \code{plotSankey()}}{
Wrapper for \code{TreatmentPatterns::createSankeyDiagram()}, but with data filtering step.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreatmentPatternsResults$plotSankey(
  age = "all",
  sex = "all",
  indexYear = "all",
  nonePaths = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{age}}{(\code{character(1)}) Age group.}

\item{\code{sex}}{(\code{character(1)}) Sex group.}

\item{\code{indexYear}}{(\code{character(1)}) Index year group.}

\item{\code{nonePaths}}{(\code{logical(1)}) Should \code{None} paths be included?}

\item{\code{...}}{Parameters for \code{TreatmentPatterns::createSankeyDiagram()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{htmlwidget}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TreatmentPatternsResults-plotEventDuration"></a>}}
\if{latex}{\out{\hypertarget{method-TreatmentPatternsResults-plotEventDuration}{}}}
\subsection{Method \code{plotEventDuration()}}{
Wrapper for \code{TreatmentPatterns::plotEventDuration()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreatmentPatternsResults$plotEventDuration(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Parameters for \code{TreatmentPatterns::plotEventDuration()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{ggplot}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TreatmentPatternsResults-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TreatmentPatternsResults-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreatmentPatternsResults$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
