% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{normplot}
\alias{normplot}
\title{Normal probability plot}
\usage{
normplot(data, var, breaks = seq(0.1, 0.9, 0.1), linecolor = "red")
}
\arguments{
\item{data}{a data frame}

\item{var}{the variable to plot (\code{data} column)}

\item{breaks}{the breaks for the y-axis}

\item{linecolor}{the color of the normal probability line}
}
\value{
a normal probability plot (GGPlot2 object)
}
\description{
Normal probability plot
}
\examples{
library(tibble)
df <- tibble(
  xn = rnorm(100, mean=20, sd=5),
  xu = runif(100, min=0, max=40)
)

df \%>\% normplot(xn)
df \%>\% normplot(xu)
}
