% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05fileRemove.r
\docType{methods}
\name{adf.file.remove}
\alias{adf.file.remove}
\alias{adf.file.remove,amigaDisk,character,logical-method}
\alias{adf.file.remove,amigaDisk,character,missing-method}
\title{Remove a file from an amigaDisk object}
\usage{
\S4method{adf.file.remove}{amigaDisk,character,logical}(x, file, full)

\S4method{adf.file.remove}{amigaDisk,character,missing}(x, file)
}
\arguments{
\item{x}{An \code{\link{amigaDisk}} onto which the file should be put.}

\item{file}{A \code{character} string of the path on the virtual floppy of the file that should be removed.
The path should be conform Amiga specs (see \code{\link{current.adf.dir}}). Wild cards are not allowed (see details).
Both files and directories can be removed from the virtual disk using this function.}

\item{full}{A \code{logical} value (default is \code{FALSE}). When set to \code{TRUE} not only pointers to
the \code{file} are removed, but also the data in the header and data blocks. When set to \code{FALSE},
the data is left as orphans on the disk. Technically, these files can be undeleted, unless they are overwritten.}
}
\value{
Returns an \code{\link{amigaDisk}} object where the
specified \code{file} is removed.
}
\description{
Remove a file from a virtual Amiga floppy disk represented by
an \code{\link{amigaDisk}} object.
}
\details{
Remove a file from a virtual Amiga floppy disk (represented by an \code{\link{amigaDisk}} object.
Make sure that the virtual disk is DOS formatted (see \code{\link{is.amigaDOS}}). This method can only remove one file at
a time from a virtual virtual disk, it is not allowed to use wild cards in the source or destination names.
It is possible to remove an entire directory at once. Use loops to remove multiple files/directories from a virtual
disk.
}
\examples{
\dontrun{
## This removes a single file from a disk
resulting.disk <- adf.file.remove(adf.example, "df0:mods/mod.intro")

## This removes the entire 's' directory and cannot be undone:
resulting.disk <- adf.file.remove(adf.example, "df0:s", TRUE)
}
}
\author{
Pepijn de Vries
}
