% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/virtual_path.R
\name{virtual_path}
\alias{virtual_path}
\title{A path pointing to a file or directory on a virtual ADF device}
\usage{
virtual_path(dev, path)
}
\arguments{
\item{dev}{A virtual ADF device (created with \code{\link[=connect_adf]{connect_adf()}} or
\code{\link[=create_adf_device]{create_adf_device()}}).
Make sure a file system is present on the virtual device or install first when missing
using \code{\link[=prepare_adf_device]{prepare_adf_device()}}.}

\item{path}{A \code{character} string representing the path to a file or directory
on the virtual device.}
}
\value{
Returns a \code{virtual_path} class object.
}
\description{
This function creates a path pointing to a file or directory
on a virtual ADF device (created with \code{\link[=connect_adf]{connect_adf()}} or \code{\link[=create_adf_device]{create_adf_device()}}).
The virtual path created with this function can be used to establish a readable
or writable connection to a file, or obtain information about a file or directory.
See also \code{vignette("virtual_paths")}
}
\examples{
# Open a connection to a virtual device:
my_device <- demo_adf()

# specify a virtual path:
my_path <- virtual_path(my_device, "DF0:s/startup-sequence")

# close the virtual device:
close(my_device)
}
\author{
Pepijn de Vries
}
