#' @title WHO Length/height-for-age for girls
#' @description WHO Length/height-for-age charts for girls from day 0 (birth) to
#' day 1856
#' @format A data frame with 1857 rows and 4 variables:
#' \describe{
#'   \item{\code{Day}}{integer Age in days}
#'   \item{\code{L}}{integer Box-Cox transformation for normality}
#'   \item{\code{M}}{double Median}
#'   \item{\code{S}}{double Coefficient of variation}
#' }
#' @family metadata
#' @keywords metadata
#' @source \url{https://www.who.int/tools/child-growth-standards/standards/length-height-for-age}
"who_lgth_ht_for_age_girls"

#' @title WHO Length/height-for-age for boys
#' @description WHO Length/height-for-age charts for boys from day 0 (birth) to
#' day 1856
#' @format A data frame with 1857 rows and 4 variables:
#' \describe{
#'   \item{\code{Day}}{integer Age in days}
#'   \item{\code{L}}{integer Box-Cox transformation for normality}
#'   \item{\code{M}}{double Median}
#'   \item{\code{S}}{double Coefficient of variation}
#' }
#' @family metadata
#' @keywords metadata
#' @source \url{https://www.who.int/tools/child-growth-standards/standards/length-height-for-age}
"who_lgth_ht_for_age_boys"

#' @title WHO Weight-for-age for girls
#' @description WHO Weight-for-age charts for girls from day 0 (birth) to
#' day 1856
#' @format A data frame with 1857 rows and 4 variables:
#' \describe{
#'   \item{\code{Day}}{integer Age in days}
#'   \item{\code{L}}{double Box-Cox transformation for normality}
#'   \item{\code{M}}{double Median}
#'   \item{\code{S}}{double Coefficient of variation}
#' }
#' @family metadata
#' @keywords metadata
#' @source \url{https://www.who.int/tools/child-growth-standards/standards/weight-for-age}
"who_wt_for_age_girls"

#' @title WHO Weight-for-age for boys
#' @description WHO Weight-for-age charts for boys from day 0 (birth) to
#' day 1856
#' @format A data frame with 1857 rows and 4 variables:
#' \describe{
#'   \item{\code{Day}}{integer Age in days}
#'   \item{\code{L}}{double Box-Cox transformation for normality}
#'   \item{\code{M}}{double Median}
#'   \item{\code{S}}{double Coefficient of variation}
#' }
#' @family metadata
#' @keywords metadata
#' @source \url{https://www.who.int/tools/child-growth-standards/standards/weight-for-age}
"who_wt_for_age_boys"

#' @title WHO Weight-for-length for girls
#' @description WHO Weight-for-length charts for girls from 45cm to 110cm
#' @format A data frame with 651 rows and 4 variables:
#' \describe{
#'   \item{\code{Length}}{double Length in cm}
#'   \item{\code{L}}{double Box-Cox transformation for normality}
#'   \item{\code{M}}{double Median}
#'   \item{\code{S}}{double Coefficient of variation}
#' }
#' @family metadata
#' @keywords metadata
#' @source \url{https://www.who.int/tools/child-growth-standards/standards/weight-for-length-height}
"who_wt_for_lgth_girls"

#' @title WHO Weight-for-length for boys
#' @description WHO Weight-for-length charts for boys from 45cm to 110cm
#' @format A data frame with 651 rows and 4 variables:
#' \describe{
#'   \item{\code{Length}}{double Length in cm}
#'   \item{\code{L}}{double Box-Cox transformation for normality}
#'   \item{\code{M}}{double Median}
#'   \item{\code{S}}{double Coefficient of variation}
#' }
#' @family metadata
#' @keywords metadata
#' @source \url{https://www.who.int/tools/child-growth-standards/standards/weight-for-length-height}
"who_wt_for_lgth_boys"

#' @title WHO BMI-for-age for girls
#' @description WHO BMI-for-age charts for girls from day 0 (birth) to
#' day 1856
#' @format A data frame with 1857 rows and 4 variables:
#' \describe{
#'   \item{\code{Day}}{integer Age in days}
#'   \item{\code{L}}{double Box-Cox transformation for normality}
#'   \item{\code{M}}{double Median}
#'   \item{\code{S}}{double Coefficient of variation}
#' }
#' @family metadata
#' @keywords metadata
#' @source \url{https://www.who.int/toolkits/child-growth-standards/standards/body-mass-index-for-age-bmi-for-age}
"who_bmi_for_age_girls"

#' @title WHO BMI-for-age for boys
#' @description WHO BMI-for-age charts for boys from day 0 (birth) to
#' day 1856
#' @format A data frame with 1857 rows and 4 variables:
#' \describe{
#'   \item{\code{Day}}{integer Age in days}
#'   \item{\code{L}}{double Box-Cox transformation for normality}
#'   \item{\code{M}}{double Median}
#'   \item{\code{S}}{double Coefficient of variation}
#' }
#' @family metadata
#' @keywords metadata
#' @source \url{https://www.who.int/toolkits/child-growth-standards/standards/body-mass-index-for-age-bmi-for-age}
"who_bmi_for_age_boys"

#' @title WHO Head circumference-for-age for girls
#' @description WHO Head circumference-for-age charts for girls from day 0 (birth) to
#' day 1856
#' @format A data frame with 1857 rows and 4 variables:
#' \describe{
#'   \item{\code{Day}}{integer Age in days}
#'   \item{\code{L}}{double Box-Cox transformation for normality}
#'   \item{\code{M}}{double Median}
#'   \item{\code{S}}{double Coefficient of variation}
#' }
#' @family metadata
#' @keywords metadata
#' @source \url{https://www.who.int/toolkits/child-growth-standards/standards/head-circumference-for-age}
"who_hc_for_age_girls"

#' @title WHO Head circumference-for-age for boys
#' @description WHO Head circumference-for-age charts for boys from day 0 (birth) to
#' day 1856
#' @format A data frame with 1857 rows and 4 variables:
#' \describe{
#'   \item{\code{Day}}{integer Age in days}
#'   \item{\code{L}}{double Box-Cox transformation for normality}
#'   \item{\code{M}}{double Median}
#'   \item{\code{S}}{double Coefficient of variation}
#' }
#' @family metadata
#' @keywords metadata
#' @source \url{https://www.who.int/toolkits/child-growth-standards/standards/head-circumference-for-age}
"who_hc_for_age_boys"

#' @title CDC Weight-for-age-chart
#' @description Weight-for-age charts, 2 to 20 years
#' @format A data frame with 436 rows and 5 variables:
#' \describe{
#'   \item{\code{SEX}}{Sex: 1 = male, 2 = female}
#'   \item{\code{AGE}}{Age in months}
#'   \item{\code{L}}{Box-Cox transformation for normality}
#'   \item{\code{M}}{Median}
#'   \item{\code{S}}{Coefficient of variation}
#' }
#' @keywords metadata
#' @family metadata
#' @source \url{https://www.cdc.gov/growthcharts/percentile_data_files.htm}
"cdc_wtage"

#' @title CDC Height-for-age-chart
#' @description Height-for-age charts, 2 to 20 years
#' @format A data frame with 436 rows and 5 variables:
#' \describe{
#'   \item{\code{SEX}}{Sex: 1 = male, 2 = female}
#'   \item{\code{AGE}}{Age in months}
#'   \item{\code{L}}{Box-Cox transformation for normality}
#'   \item{\code{M}}{Median}
#'   \item{\code{S}}{Coefficient of variation}
#' }
#' @family metadata
#' @keywords metadata
#' @source \url{https://www.cdc.gov/growthcharts/percentile_data_files.htm}
"cdc_htage"

#' @title CDC BMI-for-age-chart
#' @description BMI-for-age charts, 2 to 20.5 years
#' @format A data frame with 438 rows and 7 variables:
#' \describe{
#'   \item{\code{SEX}}{Sex: 1 = male, 2 = female}
#'   \item{\code{AGE}}{Age in months}
#'   \item{\code{L}}{Box-Cox transformation for normality}
#'   \item{\code{M}}{Median}
#'   \item{\code{S}}{Coefficient of variation}
#'   \item{\code{Sigma}}{Sigma}
#'   \item{\code{P95}}{95th Percentile}
#' }
#' @family metadata
#' @keywords metadata
#' @source \url{https://www.cdc.gov/growthcharts/percentile_data_files.htm}
"cdc_bmiage"

#' Demographic Dataset-pediatrics
#'
#' An updated SDTM DM dataset with pediatric patients
#' @keywords datasets
#' @family datasets
"dm_peds"

#' Vital signs Dataset-pediatrics
#'
#' An updated SDTM VS dataset with anthropometric measurements for pediatric patients
#' @keywords datasets
#' @family datasets
"vs_peds"

#' Subject Level Analysis Dataset-pediatrics
#'
#' An updated ADaM ADSL dataset with pediatric patients
#' @keywords datasets
#' @family datasets
"adsl_peds"
