% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/admix_model.R
\name{admix_model}
\alias{admix_model}
\title{Define the distribution/parameter(s) of the known component}
\usage{
admix_model(knownComp_dist, knownComp_param)
}
\arguments{
\item{knownComp_dist}{(Character) The name of the distribution (specified as in R glossary) of the known component
of the admixture model}

\item{knownComp_param}{(Character) A vector of the names of the parameters (specified as in R glossary) involved in
the chosen known distribution, with their values.}
}
\value{
An object of class \link[admix]{admix_model}, containing 2 attributes: 1) a list that gives the information about the distributions
involved in the two-component mixture model (the unknown and the known ones); 2) a list that gives the information about
the corresponding parameters of those distributions.
}
\description{
Create an object of class 'admix_model', containing the information about the known component distribution in the admixture model.
An admixture (aka contamination) model is a two-component mixture model with one known component.
Both the second component distribution and the mixing weight are unknown.
}
\examples{
admix_model(knownComp_dist = "norm", knownComp_param = list("mean"=0, "sd"=1))
admix_model(knownComp_dist = "exp", knownComp_param = list("rate"=2))
admix_model(knownComp_dist = "pois", knownComp_param = list("lambda"=5))
admix_model(knownComp_dist = "multinom", knownComp_param = list("size"=1, "prob"=c(0.2,0.8,0.1)))

}
\author{
Xavier Milhaud \href{mailto:xavier.milhaud.research@gmail.com}{xavier.milhaud.research@gmail.com}
}
