% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv-aglm.R
\name{cv.aglm}
\alias{cv.aglm}
\title{Fit an AGLM model with cross-validation for \eqn{\lambda}}
\usage{
cv.aglm(
  x,
  y,
  qualitative_vars_UD_only = NULL,
  qualitative_vars_both = NULL,
  qualitative_vars_OD_only = NULL,
  quantitative_vars = NULL,
  use_LVar = FALSE,
  extrapolation = "default",
  add_linear_columns = TRUE,
  add_OD_columns_of_qualitatives = TRUE,
  add_interaction_columns = FALSE,
  OD_type_of_quantitatives = "C",
  nbin.max = NULL,
  bins_list = NULL,
  bins_names = NULL,
  family = c("gaussian", "binomial", "poisson"),
  keep = FALSE,
  ...
)
}
\arguments{
\item{x}{A design matrix.
See \link{aglm} for more details.}

\item{y}{A response variable.}

\item{qualitative_vars_UD_only}{Same as in \link{aglm}.}

\item{qualitative_vars_both}{Same as in \link{aglm}.}

\item{qualitative_vars_OD_only}{Same as in \link{aglm}.}

\item{quantitative_vars}{Same as in \link{aglm}.}

\item{use_LVar}{Same as in \link{aglm}.}

\item{extrapolation}{Same as in \link{aglm}.}

\item{add_linear_columns}{Same as in \link{aglm}.}

\item{add_OD_columns_of_qualitatives}{Same as in \link{aglm}.}

\item{add_interaction_columns}{Same as in \link{aglm}.}

\item{OD_type_of_quantitatives}{Same as in \link{aglm}.}

\item{nbin.max}{Same as in \link{aglm}.}

\item{bins_list}{Same as in \link{aglm}.}

\item{bins_names}{Same as in \link{aglm}.}

\item{family}{Same as in \link{aglm}.}

\item{keep}{Set to \code{TRUE} if you need the \code{fit.preval} field in the returned value, as in \code{cv.glmnet()}.}

\item{...}{Other arguments are passed directly when calling \code{cv.glmnet()}.}
}
\value{
A model object fitted to the data with cross-validation results.
Functions such as \code{predict} and \code{plot} can be applied to the returned object, same as the result of \code{aglm()}.
See \link{AccurateGLM-class} for more details.
}
\description{
A fitting function with given \eqn{\alpha} and cross-validation for \eqn{\lambda}.
See \link{aglm-package} for more details on \eqn{\alpha} and \eqn{\lambda}.
}
\examples{

#################### Cross-validation for lambda ####################

library(aglm)
library(faraway)

## Read data
xy <- nes96

## Split data into train and test
n <- nrow(xy) # Sample size.
set.seed(2018) # For reproducibility.
test.id <- sample(n, round(n/5)) # ID numbders for test data.
test <- xy[test.id,] # test is the data.frame for testing.
train <- xy[-test.id,] # train is the data.frame for training.
x <- train[, c("popul", "TVnews", "selfLR", "ClinLR", "DoleLR", "PID", "age", "educ", "income")]
y <- train$vote
newx <- test[, c("popul", "TVnews", "selfLR", "ClinLR", "DoleLR", "PID", "age", "educ", "income")]

# NOTE: Codes bellow will take considerable time, so run it when you have time.
\donttest{

## Fit the model
model <- cv.aglm(x, y, family="binomial")

## Make the confusion matrix
lambda <- model@lambda.min
y_true <- test$vote
y_pred <- levels(y_true)[as.integer(predict(model, newx, s=lambda, type="class"))]

cat(sprintf("Confusion matrix for lambda=\%.5f:\n", lambda))
print(table(y_true, y_pred))

}
}
\references{
Suguru Fujita, Toyoto Tanaka, Kenji Kondo and Hirokazu Iwasawa. (2020)
\emph{AGLM: A Hybrid Modeling Method of GLM and Data Science Techniques}, \cr
\url{https://www.institutdesactuaires.com/global/gene/link.php?doc_id=16273&fg=1} \cr
\emph{Actuarial Colloquium Paris 2020}
}
\author{
\itemize{
\item Kenji Kondo,
\item Kazuhisa Takahashi and Hikari Banno (worked on L-Variable related features)
}
}
