% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ALE_methods.R
\name{get.ALE}
\alias{get.ALE}
\title{get method for ALE objects}
\arguments{
\item{obj}{ALE object from which to retrieve elements.}

\item{x_cols, exclude_cols}{character, list, or formula. Columns names and interaction terms from \code{obj} requested in one of the special \code{x_cols} formats. The default value of \code{NULL} for \code{x_cols} retrieves all available data of the output requested in \code{what}. See details in the documentation for \code{\link[=resolve_x_cols]{resolve_x_cols()}}.}

\item{what}{character(1). What kind of output is requested. Must be either "ale" (default) or "boot_data". To retrieve ALE statistics, see the \code{stats} argument.}

\item{...}{not used. Inserted to require explicit naming of subsequent arguments.}

\item{stats}{character(1). Retrieve ALE statistics. If \code{stats} is specified, then \code{what} must be left at the default ("ale"). Otherwise, \code{get()} errors if \code{stats} is specified and \code{what} has some other value. See the return value details below for valid values for \code{stats}.}

\item{cats}{character. Optional category names to retrieve if the ALE is for a categorical y outcome model.}

\item{ale_centre}{Same as in documentation for \code{\link[=ALEPlots]{ALEPlots()}}}

\item{simplify}{logical(1). If \code{TRUE} (default), the results will be simplified to the simplest list structure possible to give the requested results. If \code{FALSE}, a complex but consistent list structure will be returned; this might be preferred for programmatic and non-interactive use.}

\item{silent}{See documentation for \code{\link[=resolve_x_cols]{resolve_x_cols()}}}
}
\value{
Regardless of the requested data, all \code{\link[=get.ALE]{get.ALE()}} have a common structure:
\itemize{
\item If more than one category of the y outcome is returned, then the top level is a list named by each category. If, however, the y outcome is not categorical or only one category of multiple possibilities is specified using the \code{cats} argument, then the top level never has categories, regardless of the value of \code{simplify}.
\item The next level (or top level if there are zero or one category) is a list with one or two levels:
\itemize{
\item \code{d1}: 1D ALE elements.
\item \code{d2}: 2D ALE elements.
However, if elements of only one dimension (either 1D or 2D) are requested and \code{simplify = TRUE} (default), the empty list is eliminated and the level is skipped to provide only the elements present. For example, if only 1D ALE data is requested, then there will be no \code{d1} sublist but only a list of the ALE data as described for the next level. If \code{simplify = FALSE}, both \code{d1} and \code{d2} sublists will always be returned; the empty sublist will be \code{NULL}.
}
}

While all results follow the general structure just described, the specific type of data returned depends on the values of the \code{what} and \code{stats} arguments:
\describe{
\item{\code{what = 'ale'} (default) and \code{stats = NULL} (default)}{A list whose elements, named by each requested x variable, are each a tibble. The rows each represent one ALE bin. The tibble has the following columns:
* \code{var.bin} or \code{var.ceil} where \code{var} is the name of a variable (column): For non-numeric x, \code{var.bin} is the value of each of the ALE categories. For numeric x, \code{var.ceil} is the value of the upper bound (ceiling) of each ALE bin. The first "bin" of numeric variables represents the minimum value. For 2D ALE with an \code{var1} by \code{var2} interaction, both \code{var1.bin} and \code{var2.bin} columns are returned (or \code{var1.ceil} or \code{var2.ceil}for numeric \code{var1} or \code{var2}).
* \code{.n}: the number of rows of data in each bin represented by \code{var.bin} or \code{var.ceil}. For numeric x, the first bin contains all data elements that have exactly the minimum value of x. This is often 1, but might be more than 1 if more than one data element has exactly the minimum value.
* \code{.y}: the ALE function value calculated for that bin. For bootstrapped ALE, this is the same as \code{.y_mean} by default or \code{.y_median} if \code{boot_centre = 'median'}. Regardless, both \code{.y_mean} and \code{.y_median} are returned as columns here.
* \code{.y_lo}, \code{.y_hi}: the lower and upper confidence intervals, respectively, for the bootstrapped \code{.y} value based on the \code{boot_alpha} argument in the \code{\link[=ALE]{ALE()}} constructor.
}

\item{\code{what = 'boot_data'} and \code{stats = NULL} (default)}{A list whose elements, named by each requested x variable, are each a tibble. These are the data from which \code{.y_mean}, \code{.y_median}, \code{.y_lo}, and \code{.y_hi} are summarized when \code{what = 'ale'}. The rows each represent one ALE bin for a specified bootstrap iteration. The tibble has the following columns:
* \code{.it}: The bootstrap iteration. Iteration 0 represents the ALE calculations on the full dataset; the remaining values of \code{.it} are from 1 to \code{boot_it} (number of bootstrap iterations specified in the \code{\link[=ALE]{ALE()}} constructor.
* \code{var} where \code{var} is the name of a variable (column): For non-numeric x, \code{var} is the value of each of the ALE categories. For numeric x, \code{var} is the value of the upper bound (ceiling) of each ALE bin. They are otherwise similar to their meanings described for \code{what = 'ale'} above.
* \code{.n} and \code{.y}: Same as for \code{what = 'ale'}.
}

\item{\code{what = 'ale'} (default) and \code{stats = 'estimate'}}{A list with elements \code{d1} and \code{d2} with the value of each ALE statistic. Each row represents one variable or interaction. The tibble has the following columns:
* \code{term}: The variables or columns for the 1D or 2D ALE statistic.
* \code{aled}, \code{aler_min}, \code{aler_max}, \code{naled}, \code{naler_min}, \code{naler_max}: the respective ALE statistic for the variable or interaction.
}

\item{\code{what = 'ale'} (default) and \code{stats} is one or more values in \code{c('aled', 'aler_min', 'aler_max', 'naled', 'naler_min', 'naler_max')}}{A list with elements \code{d1} and \code{d2} with the distribution value of the single requested ALE statistic. Each element \code{d1} and \code{d2} is a tibble. Each row represents one statistic for one variable or interaction. The tibble has the following columns:
* \code{term}: Same as for \code{stats = 'estimate'}.
* \code{statistic}: The requested ALE statistic(s).
* \code{estimate}, \code{mean}, \code{median}: The average of the bootstrapped value of the requested statistic. \code{estimate} is equal to either \code{mean} or \code{median} depending on the \code{boot_centre} argument in the \code{\link[=ALE]{ALE()}} constructor. If ALE is not bootstrapped, then \code{estimate}, \code{mean}, and \code{median} are equal.
* \code{conf.low}, \code{conf.high}: the lower and upper confidence intervals, respectively, for the bootstrapped statistic based on the \code{boot_alpha} argument in the \code{\link[=ALE]{ALE()}} constructor. If ALE is not bootstrapped, then \code{estimate}, \code{conf.low}, and \code{conf.high} are equal.
}

\item{\code{what = 'ale'} (default) and \code{stats = 'all'}}{A list with elements \code{d1} and \code{d2} with the distribution values of all available ALE statistics for the requested variables and interactions. Whereas the \code{stats = 'aled'} (for example) format returns data for a single statistic, \code{stats = 'all'} returns all statistics for the requested variables. Thus, the data structure and columns are identical as for single statistics above, except that all available ALE statistics are returned.
}

\item{\code{what = 'ale'} (default) and \code{stats = 'conf_regions'}}{A list with elements \code{d1} and \code{d2} with the confidence regions for the requested variables and interactions. Each element is a list with the requested \code{d1} and \code{d2} sub-elements as described in the general structure above. Each data element is a tibble with confidence regions for a single variable or interaction. For an explanation of the columns, see \code{vignette('ale-statistics')}.
}

\item{\code{what = 'ale'} (default) and \code{stats = 'conf_sig'}}{Identical structure as \code{stats = 'conf_regions'} except that the elements are filtered for the terms (variables or interactions) that have statistically significant confidence regions exceeding the threshold of the inner ALER band, specifically, at least \code{obj@params$aler_alpha[2]} of the rows of data. See \code{vignette("ale-statistics")} for details.
}
}
}
\description{
Retrieve specific elements from an \code{ALE} object.
}
\examples{
# See examples at ALE() for a demonstration of how to use the get() method.


}
