% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feed.r
\name{post_thread}
\alias{post_thread}
\title{Post a thread}
\usage{
post_thread(
  texts,
  images = NULL,
  image_alts = NULL,
  thread_df = NULL,
  verbose = NULL,
  .token = NULL
)
}
\arguments{
\item{texts}{a vector of skeet (post) texts}

\item{images}{paths to images to be included in each post}

\item{image_alts}{alt texts for the images to be included in each post}

\item{thread_df}{instead of defining texts, images and image_alts, you can
also create a data frame with the information in columns of the same names.}

\item{verbose}{Whether to print status messages to the Console
(\code{TRUE}/\code{FALSE}). Package default (when \code{NULL}) is to have
status messages. Can be changed with \code{Sys.setenv(ATR_VERBOSE =
  FALSE)}.}

\item{.token}{If you manage your own tokens, you can supply it here. Usually
\code{NULL} is OK and will automatically load or guide you to generate a
token.}
}
\value{
list of the URIs and CIDs of the posts (invisible)
}
\description{
Post a thread
}
\examples{
\dontrun{
# post three messages in a thread
thread <- post_thread(c("Post 1", "Post 2", "Post 3"))

# delete the thread
delete_post(thread$uri)
}
}
