% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssgsea_wrapper.R
\name{ssgsea_wrapper}
\alias{ssgsea_wrapper}
\title{ssGSEA}
\usage{
ssgsea_wrapper(
  norm_data = "results/deseq_vst_data.txt",
  gene_id_type = c("gene_symbol", "entrez_gene", "ensembl_gene"),
  write_enrich_tables = FALSE,
  group = NULL,
  outfolder = "./ssgsea",
  full_names = FALSE,
  tpm_norm = FALSE,
  categories = c("C1", "C2", "C3", "C4", "C5", "C6", "C7", "C8", "H")
)
}
\arguments{
\item{norm_data}{Path of the normalized matrix. By default it is the "deseq_vst_data.txt" computed with the function "deseq_analysis()", but other normalized counts matrix (like TPMs) can be passed to the function. Requirements: first column gene names.}

\item{gene_id_type}{One of c("gene_symbol", "entrez_gene", "ensembl_gene"). The notation for gene names in the matrix.}

\item{write_enrich_tables}{Default = FALSE. Set to TRUE to save the matrix with enrichment scores.}

\item{group}{A matrix for the annotation on the heatmap and for grouping in the statistical analysis. Can be the path to an annotation matrix or dataframe.}

\item{outfolder}{The name to assign to the folder for output saving. (Default = "ssgsea/"). NOTE: please add "/" at the end.}

\item{full_names}{Default = FALSE, Terms full names are codified for visualization purposes. Set to TRUE to plot full names instead.}

\item{tpm_norm}{(Default = FALSE). Set to TRUE to perform a TPM normalization on counts matrix before the analysis.}

\item{categories}{Default = NULL, all the gene sets are considered. The user can specify one or more categories, like c("C1", "C2", "C3").}
}
\description{
Single-sample Gene Set Enrichment Analysis. This kind of analysis is recommended when there are too few samples. The function will generate an enrichment score for each sample and associated visualizations.

The function ssGSEA is implemented on top of GSVA package. It will produce an heatmap and a violin plot. If chosen, it will produce also the enrichment score table. All the necessary data are already provided with the autoGO package (as the MSigDB gene sets). It is possible to choose whether to perform ssGSEA with all the MSigDB (database) or with a sub-group.
}
