% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{preprocess}
\alias{preprocess}
\title{Preprocess}
\usage{
preprocess(Y, ppp, shrinkQ)
}
\arguments{
\item{Y}{An \emph{n} by \emph{p} data matrix which is to be scaled.}

\item{ppp}{An optional \emph{p} by 2 matrix where the columns represent
the sample mean and sample standard deviation of the \emph{p}th dimension of \code{Y}.}

\item{shrinkQ}{If 1, the data is shrunk according to \code{ppp}. If 0, the data is expanded
to invert a prior shrinking by \code{ppp}.}
}
\value{
A list containing \itemize{
\item{\code{Yout}:}{ A processed data matrix of observations.}
\item{\code{ppp}:}{ The shrinkage which as applied in the processing.}
}
}
\description{
Performs the pre-processing of a data matrix such that it is ready
to be used by \code{vbmfa}.
}
\examples{
Yout <- preprocess(autoMFA::MFA_testdata);

}
\references{
\insertRef{ghahramani2000variational}{autoMFA}
}
\seealso{
\code{\link{vbmfa}} for fitting models after using \code{preprocess}.
}
