% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decompose.r
\name{decompose}
\alias{decompose}
\title{Decompose a data frame based on given normalised dependencies}
\usage{
decompose(df, schema)
}
\arguments{
\item{df}{a data.frame, containing the data to be normalised.}

\item{schema}{a database schema with foreign key references, such as given by
\code{\link{autoref}}.}
}
\value{
A \code{\link{database}} object, containing the data in \code{df}
within the database schema given in \code{schema}.
}
\description{
Decomposes a data frame into several relations, based on the given database
schema. It's intended that the data frame satisfies all the functional
dependencies implied by the schema, such as if the schema was constructed
from the same data frame. If this is not the case, the function will returns
an error.
}
\details{
If the schema was constructed using approximate dependencies for the same
data frame, \code{decompose} returns an error, to prevent either duplicate records
or lossy decompositions. This is temporary: for the next update, we plan to
add an option to allow this, or to add "approximate" equivalents of databases
and database schemas.
}
