% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appendix.R
\name{initialize_to_page}
\alias{initialize_to_page}
\title{Determine Slide Insertion Page Number}
\usage{
initialize_to_page(doc_original, to_page)
}
\arguments{
\item{doc_original}{An `officer::rpptx` object representing the PowerPoint file.}

\item{to_page}{Desired slide index to insert the new slide. If `NA`, appends to the last page.}
}
\value{
A single integer value indicating the validated page number for slide insertion.
}
\description{
Computes the appropriate page number at which to insert a new slide into the PowerPoint deck.
Defaults to appending to the end if no value is provided.
}
\examples{
tmp <- tempfile(fileext = ".pptx")
doc <- officer::read_pptx()
doc <- officer::add_slide(doc, layout = "Title Slide", master = "Office Theme")
print(doc, target = tmp)
doc <- officer::read_pptx(tmp)
initialize_to_page(doc, NA) # append to end
initialize_to_page(doc, 1) # insert at page 1
}
