% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http.R
\name{comprehendHTTP}
\alias{comprehendHTTP}
\title{Execute AWS Comprehend API Request}
\usage{
comprehendHTTP(
  action,
  query = list(),
  headers = list(),
  body = NULL,
  verbose = getOption("verbose", FALSE),
  region = Sys.getenv("AWS_DEFAULT_REGION", "us-east-1"),
  key = NULL,
  secret = NULL,
  session_token = NULL,
  service = c("comprehend", "comprehendmedical"),
  ...
)
}
\arguments{
\item{action}{A character string specifying the API action to take}

\item{query}{An optional named list containing query string parameters and their character values.}

\item{headers}{A list of headers to pass to the HTTP request.}

\item{body}{A request body}

\item{verbose}{A logical indicating whether to be verbose. Default is given by \code{options("verbose")}.}

\item{region}{A character string containing the AWS region. If missing, defaults to \dQuote{us-east-1}.}

\item{key}{A character string containing an AWS Access Key ID. See \code{\link[aws.signature]{locate_credentials}}.}

\item{secret}{A character string containing an AWS Secret Access Key. See \code{\link[aws.signature]{locate_credentials}}.}

\item{session_token}{A character string containing an AWS Session Token. See \code{\link[aws.signature]{locate_credentials}}.}

\item{service}{the Comprehend service to use. Currently either `comprehend` for the base service or `comprehendmedical`
for the Comprehend Medical service.}

\item{\dots}{Additional arguments passed to \code{\link[httr]{GET}}.}
}
\value{
If successful, a named list. Otherwise, a data structure of class \dQuote{aws-error} containing any error message(s) from AWS and information about the request attempt.
}
\description{
This is the workhorse function to execute calls to the Comprehend API.
}
\details{
This function constructs and signs an Polly API request and returns the results thereof, or relevant debugging information in the case of error.
}
\author{
Thomas J. Leeper
}
