% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_gamma_regression.R
\name{plot_gamma_regression}
\alias{plot_gamma_regression}
\title{Function for plotting the mean-variance gamma regressions}
\usage{
plot_gamma_regression(data, design)
}
\arguments{
\item{data}{The data to use for producing the plots.}

\item{design}{A design matrix as produced by
\code{\link[stats]{model.matrix}}.}
}
\value{
a plot with the mean-variance trend before partitioning on the left
side, and the right side after.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Generates a scatter plot with the gamma regressions of the mean-variance
trend. Can either be ran directly with \code{plot_gamma_regression} and inputing
a design matrix, or with \code{plot_gamma} if the M-V trend has been added to the
data with \code{\link[=calculate_mean_sd_trends]{calculate_mean_sd_trends()}}.
}
\examples{
# Produce a design matrix
design <- model.matrix(~ 0 + factor(rep(1:2, each = 3)))
colnames(design) <- paste0("ng", c(50, 100))

# Normalize and log transform the data
yeast \%>\%
    # Remove missing data
    # Note that this could be replaced with imputation
    tidyr::drop_na() \%>\%
    # Normalize
    psrn("identifier") \%>\%
    plot_gamma_regression(design)
}
