% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-development-diagram.R
\name{plot_development_diagram}
\alias{plot_development_diagram}
\title{Plot a development diagram}
\usage{
plot_development_diagram(
  .phenos,
  .station = prop_stations(.phenos[[1]])[1],
  .generations = NULL,
  .colors = barrks_colors("diagram_lines"),
  .fill = barrks_colors("diagram_fill"),
  .labels = barrks_labels("diagram"),
  .legend_col = TRUE,
  .legend_lty = TRUE,
  .group = TRUE,
  .minmax_only = FALSE,
  .fun_bg = NULL,
  .lty = "solid",
  .lwd = 2,
  .date_split = NULL,
  .date_stop = NULL,
  .lty2 = "dotted",
  .lwd2 = 2,
  .fill2 = NA,
  ...
)
}
\arguments{
\item{.phenos}{List of (named) phenology objects or a single phenology that will be
plotted (see \code{\link[=phenology]{phenology()}}).}

\item{.station}{Pass a character vector to choose a station assigned to \code{pheno} by its name, or pass a different station. See \code{\link[=stations_create]{stations_create()}} for details.}

\item{.generations}{Generations that will be shown.}

\item{.colors, .fill, .labels}{Character vectors. Change the line colors, fill
or labels of the generations starting from the first generation followed
consecutively by elements for the other generations (including sister broods).}

\item{.legend_col, .legend_lty}{Manipulate the appearance of the legends for
colors and line types. Pass \code{TRUE}/\code{FALSE} to enable/disable the respective legend.
For the customization of the respective legend, a list of parameters for
\link[graphics:legend]{graphics::legend} can be passed.}

\item{.group}{Select the phenology objects that will be used to draw the filling. It can be
a character vector of the phenology names, an integer vector of the phenology
numbers, or \code{TRUE} if all phenology objects should be used.}

\item{.minmax_only}{If \code{TRUE}, only the minimum and the maximum development
line will be plotted.}

\item{.fun_bg}{Function to draw a background.}

\item{.lty, .lwd}{Use specific line types and line widths.
Vectors of the same length as \code{.phenos} will assign the values to the
respective phenology.}

\item{.date_split, .lty2, .lwd2, .fill2}{When \code{.date_split} is reached, the
appearance of the plot will change according to the respective values.}

\item{.date_stop}{If specified, no data will be plotted after the respective
date.}

\item{...}{Parameters passed to \code{\link[base:plot]{base::plot()}}.}
}
\value{
None
}
\description{
A development diagram illustrates the beetles' development of all appearing
generations within a year.
}
\examples{
\donttest{
# calculate phenology
p <- phenology('phenips-clim', barrks_data('stations'), .quiet = TRUE)

# plot development diagram of the station 'Mannheim'
plot_development_diagram(p, 'Mannheim', .lwd = 4, .legend_lty = FALSE)
}
}
\seealso{
\link{stations}
}
