% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_betaselect_methods.R
\name{getCall.lm_betaselect}
\alias{getCall.lm_betaselect}
\alias{getCall.glm_betaselect}
\title{Call in an
'lm_betaselect' or 'glm_betaselect'
Object}
\usage{
\method{getCall}{lm_betaselect}(
  x,
  what = c("lm_betaselect", "beta", "standardized", "raw", "unstandardized"),
  ...
)

\method{getCall}{glm_betaselect}(
  x,
  what = c("glm_betaselect", "beta", "standardized", "raw", "unstandardized"),
  ...
)
}
\arguments{
\item{x}{An \code{lm_betaselect}-class
or \code{glm_betaselect}-class
object from which the call is to
be extracted.}

\item{what}{Which call to extract.
For \code{"lm_betaselect"} or
\code{"glm_betaselect"} the call
to \code{\link[=lm_betaselect]{lm_betaselect()}}
or \code{\link[=glm_betaselect]{glm_betaselect()}} is extracted.
For
\code{"beta"} or \code{"standardized"}, the
call used to fit the model \emph{after}
selected variables standardized
is extracted.
For \code{"raw"}
or \code{"unstandardized"}, the call used
to fit hte model \emph{before} standardization
is extracted.}

\item{...}{Additional arguments.
Ignored.}
}
\value{
It returns the call requested.
}
\description{
The \code{getCall}-method
for an \code{lm_betaselect}-class or
\code{glm_betaselectd}-class objects.
}
\details{
This works in the same way
the default \code{getCall}-method does for
the outputs of \code{\link[stats:lm]{stats::lm()}}
and \code{\link[stats:glm]{stats::glm()}}.
}
\examples{

data(data_test_mod_cat)

lm_beta_x <- lm_betaselect(dv ~ iv*mod + cov1,
                           data = data_test_mod_cat,
                           to_standardize = "iv")
getCall(lm_beta_x)
getCall(lm_beta_x, what = "beta")
getCall(lm_beta_x, what = "raw")

}
\seealso{
\code{\link[=lm_betaselect]{lm_betaselect()}},
\code{\link[=glm_betaselect]{glm_betaselect()}}, and \code{\link[stats:update]{stats::getCall()}}
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
