% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_size.R
\name{sample_size}
\alias{sample_size}
\alias{print.sample_size}
\title{Sample Size Calculation for Clinical Trials}
\usage{
sample_size(
  sample = c("one-sample", "two-sample"),
  design = NULL,
  outcome = c("mean", "proportion"),
  type = c("equality", "equivalence", "non-inferiority", "superiority"),
  alpha = 0.05,
  beta = 0.2,
  x1 = NULL,
  x2 = NULL,
  SD = NULL,
  delta = NULL,
  dropout = 0,
  k = 1
)

\method{print}{sample_size}(x, ...)
}
\arguments{
\item{sample}{Character string indicating whether one or two samples need to be calculated.
Options: "one-sample" or "two-sample".}

\item{design}{Character string indicating study design when sample = "two-sample".
Options: "parallel" or "crossover". Default: NULL for one-sample tests.}

\item{outcome}{Character string indicating the type of outcome variable.
Options: "mean" or "proportion".}

\item{type}{Character string indicating the type of hypothesis test.
Options: "equality", "equivalence", "non-inferiority", or "superiority".}

\item{alpha}{Numeric parameter indicating the Type I error rate (significance level). Default: 0.05.}

\item{beta}{Numeric parameter indicating the Type II error rate (1 - power). Default: 0.20.}

\item{x1}{Numeric value of the mean or proportion for group 1 (treatment group).}

\item{x2}{Numeric value of the mean or proportion for group 2 (control group or reference value).}

\item{SD}{Numeric value indicating the standard deviation. Required for mean outcomes and crossover
designs with proportion outcomes. Default: NULL.}

\item{delta}{Numeric value indicating the margin of clinical interest. Required for non-equality tests.
Must be negative for non-inferiority and positive for superiority/equivalence. Default: NULL.}

\item{dropout}{Numeric value indicating the discontinuation rate expected in the study.
Must be between 0 and 1. Default: 0.}

\item{k}{Numeric value indicating the allocation ratio (n1/n2) for two-sample tests. Default: 1.}

\item{x}{An object of class "sample_size".}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
An object of class "sample_size" containing the calculated sample size and study parameters.
}
\description{
Calculates the sample size needed in a clinical trial based on study design
and statistical parameters using standard formulas for hypothesis testing (Chow, S. 2008).
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(sample_size)}: Print method for objects of class "sample_size".

}}
\examples{
# Two-sample parallel non-inferiority test for means with 10\% expected dropout
sample_size(sample = 'two-sample', design = 'parallel', outcome = 'mean',
            type = 'non-inferiority', x1 = 5.0, x2 = 5.0, 
            SD = 0.1, delta = -0.05, k = 1, dropout = 0.1)
            
# One-sample equivalence test for means
sample_size(sample = "one-sample", outcome = "mean", type = "equivalence",
            x1 = 0, x2 = 0, SD = 0.1, delta = 0.05)

}
\references{
Chow, S.-C., Shao, J., Wang, H., & Lokhnygina, Y. (2017). Sample Size Calculations
in Clinical Research (3rd ed.). Chapman and Hall/CRC. https://doi.org/10.1201/9781315183084
}
