// Generated by rstantools.  Do not edit by hand.

/*
    bmstdr is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    bmstdr is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with bmstdr.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_gp_marginal_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'gp_marginal', line 34, column 2 to column 17)",
                                                      " (in 'gp_marginal', line 35, column 2 to column 20)",
                                                      " (in 'gp_marginal', line 36, column 2 to column 25)",
                                                      " (in 'gp_marginal', line 37, column 2 to column 23)",
                                                      " (in 'gp_marginal', line 38, column 2 to column 36)",
                                                      " (in 'gp_marginal', line 41, column 7 to column 9)",
                                                      " (in 'gp_marginal', line 41, column 0 to column 19)",
                                                      " (in 'gp_marginal', line 42, column 7 to column 9)",
                                                      " (in 'gp_marginal', line 42, column 11 to column 13)",
                                                      " (in 'gp_marginal', line 42, column 0 to column 19)",
                                                      " (in 'gp_marginal', line 43, column 7 to column 9)",
                                                      " (in 'gp_marginal', line 43, column 11 to column 13)",
                                                      " (in 'gp_marginal', line 43, column 0 to column 20)",
                                                      " (in 'gp_marginal', line 44, column 8 to column 10)",
                                                      " (in 'gp_marginal', line 44, column 0 to column 12)",
                                                      " (in 'gp_marginal', line 45, column 8 to column 10)",
                                                      " (in 'gp_marginal', line 45, column 12 to column 14)",
                                                      " (in 'gp_marginal', line 45, column 0 to column 18)",
                                                      " (in 'gp_marginal', line 46, column 8 to column 10)",
                                                      " (in 'gp_marginal', line 46, column 12 to column 14)",
                                                      " (in 'gp_marginal', line 46, column 0 to column 22)",
                                                      " (in 'gp_marginal', line 47, column 0 to column 7)",
                                                      " (in 'gp_marginal', line 48, column 1 to column 56)",
                                                      " (in 'gp_marginal', line 49, column 1 to column 50)",
                                                      " (in 'gp_marginal', line 50, column 20 to column 74)",
                                                      " (in 'gp_marginal', line 50, column 1 to column 74)",
                                                      " (in 'gp_marginal', line 51, column 20 to column 72)",
                                                      " (in 'gp_marginal', line 51, column 1 to column 72)",
                                                      " (in 'gp_marginal', line 52, column 20 to column 73)",
                                                      " (in 'gp_marginal', line 52, column 1 to column 73)",
                                                      " (in 'gp_marginal', line 53, column 16 to column 84)",
                                                      " (in 'gp_marginal', line 53, column 1 to column 84)",
                                                      " (in 'gp_marginal', line 56, column 5 to column 53)",
                                                      " (in 'gp_marginal', line 58, column 5 to column 29)",
                                                      " (in 'gp_marginal', line 55, column 18 to line 59, column 4)",
                                                      " (in 'gp_marginal', line 55, column 0 to line 59, column 4)",
                                                      " (in 'gp_marginal', line 54, column 18 to line 60, column 2)",
                                                      " (in 'gp_marginal', line 54, column 0 to line 60, column 2)",
                                                      " (in 'gp_marginal', line 61, column 15 to column 47)",
                                                      " (in 'gp_marginal', line 61, column 0 to column 47)",
                                                      " (in 'gp_marginal', line 62, column 0 to column 30)",
                                                      " (in 'gp_marginal', line 63, column 0 to column 19)",
                                                      " (in 'gp_marginal', line 65, column 4 to column 34)",
                                                      " (in 'gp_marginal', line 64, column 0 to line 65, column 34)",
                                                      " (in 'gp_marginal', line 69, column 4 to column 37)",
                                                      " (in 'gp_marginal', line 68, column 1 to line 69, column 37)",
                                                      " (in 'gp_marginal', line 67, column 16 to line 70, column 1)",
                                                      " (in 'gp_marginal', line 67, column 0 to line 70, column 1)",
                                                      " (in 'gp_marginal', line 73, column 5 to column 37)",
                                                      " (in 'gp_marginal', line 74, column 5 to column 41)",
                                                      " (in 'gp_marginal', line 72, column 18 to line 75, column 4)",
                                                      " (in 'gp_marginal', line 72, column 2 to line 75, column 4)",
                                                      " (in 'gp_marginal', line 71, column 16 to line 76, column 1)",
                                                      " (in 'gp_marginal', line 71, column 0 to line 76, column 1)",
                                                      " (in 'gp_marginal', line 78, column 1 to column 44)",
                                                      " (in 'gp_marginal', line 77, column 18 to line 79, column 2)",
                                                      " (in 'gp_marginal', line 77, column 1 to line 79, column 2)",
                                                      " (in 'gp_marginal', line 81, column 1 to column 23)",
                                                      " (in 'gp_marginal', line 82, column 1 to column 32)",
                                                      " (in 'gp_marginal', line 83, column 1 to column 28)",
                                                      " (in 'gp_marginal', line 84, column 1 to column 28)",
                                                      " (in 'gp_marginal', line 80, column 15 to line 85, column 1)",
                                                      " (in 'gp_marginal', line 80, column 0 to line 85, column 1)",
                                                      " (in 'gp_marginal', line 12, column 0 to column 16)",
                                                      " (in 'gp_marginal', line 13, column 0 to column 16)",
                                                      " (in 'gp_marginal', line 14, column 0 to column 16)",
                                                      " (in 'gp_marginal', line 15, column 0 to column 15)",
                                                      " (in 'gp_marginal', line 16, column 0 to column 20)",
                                                      " (in 'gp_marginal', line 17, column 0 to column 19)",
                                                      " (in 'gp_marginal', line 18, column 0 to column 31)",
                                                      " (in 'gp_marginal', line 19, column 18 to column 24)",
                                                      " (in 'gp_marginal', line 19, column 0 to column 26)",
                                                      " (in 'gp_marginal', line 20, column 17 to column 22)",
                                                      " (in 'gp_marginal', line 20, column 0 to column 24)",
                                                      " (in 'gp_marginal', line 21, column 10 to column 15)",
                                                      " (in 'gp_marginal', line 21, column 0 to column 17)",
                                                      " (in 'gp_marginal', line 22, column 7 to column 9)",
                                                      " (in 'gp_marginal', line 22, column 11 to column 12)",
                                                      " (in 'gp_marginal', line 22, column 0 to column 16)",
                                                      " (in 'gp_marginal', line 23, column 0 to column 30)",
                                                      " (in 'gp_marginal', line 24, column 0 to column 28)",
                                                      " (in 'gp_marginal', line 25, column 0 to column 21)",
                                                      " (in 'gp_marginal', line 26, column 0 to column 34)",
                                                      " (in 'gp_marginal', line 27, column 7 to column 9)",
                                                      " (in 'gp_marginal', line 27, column 11 to column 13)",
                                                      " (in 'gp_marginal', line 27, column 0 to column 20)",
                                                      " (in 'gp_marginal', line 28, column 0 to column 22)",
                                                      " (in 'gp_marginal', line 31, column 9 to column 11)",
                                                      " (in 'gp_marginal', line 31, column 2 to column 38)",
                                                      " (in 'gp_marginal', line 34, column 9 to column 10)",
                                                      " (in 'gp_marginal', line 38, column 14 to column 34)"};
#include <stan_meta_header.hpp>
class model_gp_marginal final : public model_base_crtp<model_gp_marginal> {
private:
  int sn;
  int tn;
  int nT;
  int p;
  int ntmiss;
  int ntobs;
  int missing;
  std::vector<int> data_miss_idx;
  std::vector<int> data_obs_idx;
  std::vector<double> yobs;
  Eigen::Matrix<double, -1, -1> X;
  std::vector<double> sigma2_prior;
  std::vector<double> tau2_prior;
  int phidist;
  std::vector<double> prior_phi_param;
  Eigen::Matrix<double, -1, -1> dist;
  int verbose;
  Eigen::Matrix<double, -1, 1> mu_0;
  int z_miss_1dim__;
 
public:
  ~model_gp_marginal() { }
  
  inline std::string model_name() const final { return "model_gp_marginal"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_gp_marginal(stan::io::var_context& context__,
                    unsigned int random_seed__ = 0,
                    std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_gp_marginal_namespace::model_gp_marginal";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 64;
      context__.validate_dims("data initialization","sn","int",
          context__.to_vec());
      sn = std::numeric_limits<int>::min();
      
      current_statement__ = 64;
      sn = context__.vals_i("sn")[(1 - 1)];
      current_statement__ = 64;
      current_statement__ = 64;
      check_greater_or_equal(function__, "sn", sn, 0);
      current_statement__ = 65;
      context__.validate_dims("data initialization","tn","int",
          context__.to_vec());
      tn = std::numeric_limits<int>::min();
      
      current_statement__ = 65;
      tn = context__.vals_i("tn")[(1 - 1)];
      current_statement__ = 65;
      current_statement__ = 65;
      check_greater_or_equal(function__, "tn", tn, 0);
      current_statement__ = 66;
      context__.validate_dims("data initialization","nT","int",
          context__.to_vec());
      nT = std::numeric_limits<int>::min();
      
      current_statement__ = 66;
      nT = context__.vals_i("nT")[(1 - 1)];
      current_statement__ = 66;
      current_statement__ = 66;
      check_greater_or_equal(function__, "nT", nT, 0);
      current_statement__ = 67;
      context__.validate_dims("data initialization","p","int",
          context__.to_vec());
      p = std::numeric_limits<int>::min();
      
      current_statement__ = 67;
      p = context__.vals_i("p")[(1 - 1)];
      current_statement__ = 67;
      current_statement__ = 67;
      check_greater_or_equal(function__, "p", p, 0);
      current_statement__ = 68;
      context__.validate_dims("data initialization","ntmiss","int",
          context__.to_vec());
      ntmiss = std::numeric_limits<int>::min();
      
      current_statement__ = 68;
      ntmiss = context__.vals_i("ntmiss")[(1 - 1)];
      current_statement__ = 68;
      current_statement__ = 68;
      check_greater_or_equal(function__, "ntmiss", ntmiss, 0);
      current_statement__ = 69;
      context__.validate_dims("data initialization","ntobs","int",
          context__.to_vec());
      ntobs = std::numeric_limits<int>::min();
      
      current_statement__ = 69;
      ntobs = context__.vals_i("ntobs")[(1 - 1)];
      current_statement__ = 69;
      current_statement__ = 69;
      check_greater_or_equal(function__, "ntobs", ntobs, 0);
      current_statement__ = 70;
      context__.validate_dims("data initialization","missing","int",
          context__.to_vec());
      missing = std::numeric_limits<int>::min();
      
      current_statement__ = 70;
      missing = context__.vals_i("missing")[(1 - 1)];
      current_statement__ = 70;
      current_statement__ = 70;
      check_greater_or_equal(function__, "missing", missing, 0);
      current_statement__ = 70;
      current_statement__ = 70;
      check_less_or_equal(function__, "missing", missing, 1);
      current_statement__ = 71;
      validate_non_negative_index("data_miss_idx", "ntmiss", ntmiss);
      current_statement__ = 72;
      context__.validate_dims("data initialization","data_miss_idx","int",
          context__.to_vec(ntmiss));
      data_miss_idx = std::vector<int>(ntmiss, std::numeric_limits<int>::min());
      
      current_statement__ = 72;
      assign(data_miss_idx, nil_index_list(),
        context__.vals_i("data_miss_idx"), "assigning variable data_miss_idx");
      current_statement__ = 73;
      validate_non_negative_index("data_obs_idx", "ntobs", ntobs);
      current_statement__ = 74;
      context__.validate_dims("data initialization","data_obs_idx","int",
          context__.to_vec(ntobs));
      data_obs_idx = std::vector<int>(ntobs, std::numeric_limits<int>::min());
      
      current_statement__ = 74;
      assign(data_obs_idx, nil_index_list(),
        context__.vals_i("data_obs_idx"), "assigning variable data_obs_idx");
      current_statement__ = 75;
      validate_non_negative_index("yobs", "ntobs", ntobs);
      current_statement__ = 76;
      context__.validate_dims("data initialization","yobs","double",
          context__.to_vec(ntobs));
      yobs = std::vector<double>(ntobs, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 76;
      assign(yobs, nil_index_list(), context__.vals_r("yobs"),
        "assigning variable yobs");
      current_statement__ = 77;
      validate_non_negative_index("X", "nT", nT);
      current_statement__ = 78;
      validate_non_negative_index("X", "p", p);
      current_statement__ = 79;
      context__.validate_dims("data initialization","X","double",
          context__.to_vec(nT, p));
      X = Eigen::Matrix<double, -1, -1>(nT, p);
      stan::math::fill(X, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 79;
        assign(X_flat__, nil_index_list(), context__.vals_r("X"),
          "assigning variable X_flat__");
        current_statement__ = 79;
        pos__ = 1;
        current_statement__ = 79;
        for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
          current_statement__ = 79;
          for (int sym2__ = 1; sym2__ <= nT; ++sym2__) {
            current_statement__ = 79;
            assign(X,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              X_flat__[(pos__ - 1)], "assigning variable X");
            current_statement__ = 79;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 80;
      context__.validate_dims("data initialization","sigma2_prior","double",
          context__.to_vec(2));
      sigma2_prior = std::vector<double>(2, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 80;
      assign(sigma2_prior, nil_index_list(),
        context__.vals_r("sigma2_prior"), "assigning variable sigma2_prior");
      current_statement__ = 80;
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        current_statement__ = 80;
        current_statement__ = 80;
        check_greater_or_equal(function__, "sigma2_prior[sym1__]",
                               sigma2_prior[(sym1__ - 1)], 0);}
      current_statement__ = 81;
      context__.validate_dims("data initialization","tau2_prior","double",
          context__.to_vec(2));
      tau2_prior = std::vector<double>(2, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 81;
      assign(tau2_prior, nil_index_list(), context__.vals_r("tau2_prior"),
        "assigning variable tau2_prior");
      current_statement__ = 81;
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        current_statement__ = 81;
        current_statement__ = 81;
        check_greater_or_equal(function__, "tau2_prior[sym1__]",
                               tau2_prior[(sym1__ - 1)], 0);}
      current_statement__ = 82;
      context__.validate_dims("data initialization","phidist","int",
          context__.to_vec());
      phidist = std::numeric_limits<int>::min();
      
      current_statement__ = 82;
      phidist = context__.vals_i("phidist")[(1 - 1)];
      current_statement__ = 82;
      current_statement__ = 82;
      check_greater_or_equal(function__, "phidist", phidist, 0);
      current_statement__ = 83;
      context__.validate_dims("data initialization","prior_phi_param",
          "double",context__.to_vec(2));
      prior_phi_param = std::vector<double>(2, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 83;
      assign(prior_phi_param, nil_index_list(),
        context__.vals_r("prior_phi_param"),
        "assigning variable prior_phi_param");
      current_statement__ = 83;
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        current_statement__ = 83;
        current_statement__ = 83;
        check_greater_or_equal(function__, "prior_phi_param[sym1__]",
                               prior_phi_param[(sym1__ - 1)], 0);}
      current_statement__ = 84;
      validate_non_negative_index("dist", "sn", sn);
      current_statement__ = 85;
      validate_non_negative_index("dist", "sn", sn);
      current_statement__ = 86;
      context__.validate_dims("data initialization","dist","double",
          context__.to_vec(sn, sn));
      dist = Eigen::Matrix<double, -1, -1>(sn, sn);
      stan::math::fill(dist, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> dist_flat__;
        current_statement__ = 86;
        assign(dist_flat__, nil_index_list(), context__.vals_r("dist"),
          "assigning variable dist_flat__");
        current_statement__ = 86;
        pos__ = 1;
        current_statement__ = 86;
        for (int sym1__ = 1; sym1__ <= sn; ++sym1__) {
          current_statement__ = 86;
          for (int sym2__ = 1; sym2__ <= sn; ++sym2__) {
            current_statement__ = 86;
            assign(dist,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              dist_flat__[(pos__ - 1)], "assigning variable dist");
            current_statement__ = 86;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 87;
      context__.validate_dims("data initialization","verbose","int",
          context__.to_vec());
      verbose = std::numeric_limits<int>::min();
      
      current_statement__ = 87;
      verbose = context__.vals_i("verbose")[(1 - 1)];
      current_statement__ = 87;
      current_statement__ = 87;
      check_greater_or_equal(function__, "verbose", verbose, 0);
      current_statement__ = 88;
      validate_non_negative_index("mu_0", "sn", sn);
      current_statement__ = 89;
      mu_0 = Eigen::Matrix<double, -1, 1>(sn);
      stan::math::fill(mu_0, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 89;
      assign(mu_0, nil_index_list(), rep_vector(0, sn),
        "assigning variable mu_0");
      current_statement__ = 90;
      validate_non_negative_index("beta", "p", p);
      current_statement__ = 91;
      z_miss_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 91;
      z_miss_1dim__ = (missing ? ntmiss : 0);
      current_statement__ = 91;
      validate_non_negative_index("z_miss", "missing ? ntmiss : 0",
                                  z_miss_1dim__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += p;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += z_miss_1dim__;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_gp_marginal_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> beta;
      beta = Eigen::Matrix<local_scalar_t__, -1, 1>(p);
      stan::math::fill(beta, DUMMY_VAR__);
      
      current_statement__ = 1;
      beta = in__.vector(p);
      local_scalar_t__ phi;
      phi = DUMMY_VAR__;
      
      current_statement__ = 2;
      phi = in__.scalar();
      current_statement__ = 2;
      if (jacobian__) {
        current_statement__ = 2;
        phi = stan::math::lb_constrain(phi, 0, lp__);
      } else {
        current_statement__ = 2;
        phi = stan::math::lb_constrain(phi, 0);
      }
      local_scalar_t__ sigma_sq;
      sigma_sq = DUMMY_VAR__;
      
      current_statement__ = 3;
      sigma_sq = in__.scalar();
      current_statement__ = 3;
      if (jacobian__) {
        current_statement__ = 3;
        sigma_sq = stan::math::lb_constrain(sigma_sq, 0, lp__);
      } else {
        current_statement__ = 3;
        sigma_sq = stan::math::lb_constrain(sigma_sq, 0);
      }
      local_scalar_t__ tau_sq;
      tau_sq = DUMMY_VAR__;
      
      current_statement__ = 4;
      tau_sq = in__.scalar();
      current_statement__ = 4;
      if (jacobian__) {
        current_statement__ = 4;
        tau_sq = stan::math::lb_constrain(tau_sq, 0, lp__);
      } else {
        current_statement__ = 4;
        tau_sq = stan::math::lb_constrain(tau_sq, 0);
      }
      std::vector<local_scalar_t__> z_miss;
      z_miss = std::vector<local_scalar_t__>(z_miss_1dim__, DUMMY_VAR__);
      
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= z_miss_1dim__; ++sym1__) {
        current_statement__ = 5;
        assign(z_miss, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable z_miss");}
      {
        current_statement__ = 6;
        validate_non_negative_index("xbmodel", "nT", nT);
        Eigen::Matrix<local_scalar_t__, -1, 1> xbmodel;
        xbmodel = Eigen::Matrix<local_scalar_t__, -1, 1>(nT);
        stan::math::fill(xbmodel, DUMMY_VAR__);
        
        current_statement__ = 8;
        validate_non_negative_index("mus", "tn", tn);
        current_statement__ = 9;
        validate_non_negative_index("mus", "sn", sn);
        Eigen::Matrix<local_scalar_t__, -1, -1> mus;
        mus = Eigen::Matrix<local_scalar_t__, -1, -1>(tn, sn);
        stan::math::fill(mus, DUMMY_VAR__);
        
        current_statement__ = 11;
        validate_non_negative_index("dats", "tn", tn);
        current_statement__ = 12;
        validate_non_negative_index("dats", "sn", sn);
        Eigen::Matrix<local_scalar_t__, -1, -1> dats;
        dats = Eigen::Matrix<local_scalar_t__, -1, -1>(tn, sn);
        stan::math::fill(dats, DUMMY_VAR__);
        
        current_statement__ = 14;
        validate_non_negative_index("z1", "nT", nT);
        std::vector<local_scalar_t__> z1;
        z1 = std::vector<local_scalar_t__>(nT, DUMMY_VAR__);
        
        current_statement__ = 16;
        validate_non_negative_index("L", "sn", sn);
        current_statement__ = 17;
        validate_non_negative_index("L", "sn", sn);
        Eigen::Matrix<local_scalar_t__, -1, -1> L;
        L = Eigen::Matrix<local_scalar_t__, -1, -1>(sn, sn);
        stan::math::fill(L, DUMMY_VAR__);
        
        current_statement__ = 19;
        validate_non_negative_index("Sigma", "sn", sn);
        current_statement__ = 20;
        validate_non_negative_index("Sigma", "sn", sn);
        Eigen::Matrix<local_scalar_t__, -1, -1> Sigma;
        Sigma = Eigen::Matrix<local_scalar_t__, -1, -1>(sn, sn);
        stan::math::fill(Sigma, DUMMY_VAR__);
        
        local_scalar_t__ u;
        u = DUMMY_VAR__;
        
        current_statement__ = 23;
        lp_accum__.add(
          inv_gamma_lpdf<propto__>(sigma_sq, sigma2_prior[(1 - 1)],
            sigma2_prior[(2 - 1)]));
        current_statement__ = 24;
        lp_accum__.add(
          inv_gamma_lpdf<propto__>(tau_sq, tau2_prior[(1 - 1)],
            tau2_prior[(2 - 1)]));
        current_statement__ = 26;
        if (logical_eq(phidist, 0)) {
          current_statement__ = 25;
          lp_accum__.add(
            uniform_lpdf<propto__>(phi, prior_phi_param[(1 - 1)],
              prior_phi_param[(2 - 1)]));
        } 
        current_statement__ = 28;
        if (logical_eq(phidist, 1)) {
          current_statement__ = 27;
          lp_accum__.add(
            gamma_lpdf<propto__>(phi, prior_phi_param[(1 - 1)],
              prior_phi_param[(2 - 1)]));
        } 
        current_statement__ = 30;
        if (logical_eq(phidist, 2)) {
          current_statement__ = 29;
          lp_accum__.add(
            cauchy_lpdf<propto__>(phi, prior_phi_param[(1 - 1)],
              prior_phi_param[(2 - 1)]));
        } 
        current_statement__ = 32;
        if (logical_gt(phidist, 2)) {
          current_statement__ = 31;
          std::stringstream errmsg_stream__;
          errmsg_stream__ << "Wrong prior distribution for phi; found phidist=";
          errmsg_stream__ << phidist;
          throw std::domain_error(errmsg_stream__.str());
        } 
        current_statement__ = 38;
        for (int i = 1; i <= (sn - 1); ++i) {
          current_statement__ = 36;
          for (int j = (i + 1); j <= sn; ++j) {
            current_statement__ = 33;
            assign(Sigma,
              cons_list(index_uni(i),
                cons_list(index_uni(j), nil_index_list())),
              (sigma_sq *
                stan::math::exp(
                  ((-1 * phi) *
                    rvalue(dist,
                      cons_list(index_uni(i),
                        cons_list(index_uni(j), nil_index_list())), "dist")))),
              "assigning variable Sigma");
            current_statement__ = 34;
            assign(Sigma,
              cons_list(index_uni(j),
                cons_list(index_uni(i), nil_index_list())),
              rvalue(Sigma,
                cons_list(index_uni(i),
                  cons_list(index_uni(j), nil_index_list())), "Sigma"),
              "assigning variable Sigma");}}
        current_statement__ = 40;
        for (int i = 1; i <= sn; ++i) {
          current_statement__ = 39;
          assign(Sigma,
            cons_list(index_uni(i),
              cons_list(index_uni(i), nil_index_list())),
            (sigma_sq + tau_sq), "assigning variable Sigma");}
        current_statement__ = 41;
        assign(L, nil_index_list(), cholesky_decompose(Sigma),
          "assigning variable L");
        current_statement__ = 42;
        assign(xbmodel, nil_index_list(), multiply(X, beta),
          "assigning variable xbmodel");
        current_statement__ = 44;
        for (int i = 1; i <= ntobs; ++i) {
          current_statement__ = 43;
          assign(z1,
            cons_list(index_uni(data_obs_idx[(i - 1)]), nil_index_list()),
            yobs[(i - 1)], "assigning variable z1");}
        current_statement__ = 48;
        if (logical_gt(missing, 0)) {
          current_statement__ = 46;
          for (int k = 1; k <= ntmiss; ++k) {
            current_statement__ = 45;
            assign(z1,
              cons_list(index_uni(data_miss_idx[(k - 1)]), nil_index_list()),
              z_miss[(k - 1)], "assigning variable z1");}
        } 
        current_statement__ = 54;
        for (int i = 1; i <= tn; ++i) {
          current_statement__ = 52;
          for (int j = 1; j <= sn; ++j) {
            current_statement__ = 49;
            assign(dats,
              cons_list(index_uni(i),
                cons_list(index_uni(j), nil_index_list())),
              z1[((i + ((j - 1) * tn)) - 1)], "assigning variable dats");
            current_statement__ = 50;
            assign(mus,
              cons_list(index_uni(i),
                cons_list(index_uni(j), nil_index_list())),
              xbmodel[((i + ((j - 1) * tn)) - 1)], "assigning variable mus");
          }}
        current_statement__ = 57;
        for (int t = 1; t <= tn; ++t) {
          current_statement__ = 55;
          lp_accum__.add(
            multi_normal_cholesky_lpdf<propto__>(
              rvalue(dats, cons_list(index_uni(t), nil_index_list()), "dats"),
              rvalue(mus, cons_list(index_uni(t), nil_index_list()), "mus"),
              L));}
        current_statement__ = 63;
        if (logical_gt(verbose, 0)) {
          current_statement__ = 58;
          if (pstream__) {
            stan_print(pstream__, "beta= ");
            stan_print(pstream__, beta);
            stan_print(pstream__, "\n");
          }
          current_statement__ = 59;
          if (pstream__) {
            stan_print(pstream__, "sigma sq = ");
            stan_print(pstream__, sigma_sq);
            stan_print(pstream__, "\n");
          }
          current_statement__ = 60;
          if (pstream__) {
            stan_print(pstream__, "tau sq = ");
            stan_print(pstream__, tau_sq);
            stan_print(pstream__, "\n");
          }
          current_statement__ = 61;
          if (pstream__) {
            stan_print(pstream__, "range = ");
            stan_print(pstream__, (3.0 / phi));
            stan_print(pstream__, "\n");
          }
        } 
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_gp_marginal_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(p);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      beta = in__.vector(p);
      double phi;
      phi = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      phi = in__.scalar();
      current_statement__ = 2;
      phi = stan::math::lb_constrain(phi, 0);
      double sigma_sq;
      sigma_sq = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      sigma_sq = in__.scalar();
      current_statement__ = 3;
      sigma_sq = stan::math::lb_constrain(sigma_sq, 0);
      double tau_sq;
      tau_sq = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      tau_sq = in__.scalar();
      current_statement__ = 4;
      tau_sq = stan::math::lb_constrain(tau_sq, 0);
      std::vector<double> z_miss;
      z_miss = std::vector<double>(z_miss_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= z_miss_1dim__; ++sym1__) {
        current_statement__ = 5;
        assign(z_miss, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable z_miss");}
      for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
      vars__.emplace_back(phi);
      vars__.emplace_back(sigma_sq);
      vars__.emplace_back(tau_sq);
      for (int sym1__ = 1; sym1__ <= z_miss_1dim__; ++sym1__) {
        vars__.emplace_back(z_miss[(sym1__ - 1)]);}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(p);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta_flat__;
        current_statement__ = 1;
        assign(beta_flat__, nil_index_list(), context__.vals_r("beta"),
          "assigning variable beta_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
          current_statement__ = 1;
          assign(beta, cons_list(index_uni(sym1__), nil_index_list()),
            beta_flat__[(pos__ - 1)], "assigning variable beta");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      double phi;
      phi = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      phi = context__.vals_r("phi")[(1 - 1)];
      double phi_free__;
      phi_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      phi_free__ = stan::math::lb_free(phi, 0);
      double sigma_sq;
      sigma_sq = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      sigma_sq = context__.vals_r("sigma_sq")[(1 - 1)];
      double sigma_sq_free__;
      sigma_sq_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      sigma_sq_free__ = stan::math::lb_free(sigma_sq, 0);
      double tau_sq;
      tau_sq = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      tau_sq = context__.vals_r("tau_sq")[(1 - 1)];
      double tau_sq_free__;
      tau_sq_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      tau_sq_free__ = stan::math::lb_free(tau_sq, 0);
      std::vector<double> z_miss;
      z_miss = std::vector<double>(z_miss_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      assign(z_miss, nil_index_list(), context__.vals_r("z_miss"),
        "assigning variable z_miss");
      for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
      vars__.emplace_back(phi_free__);
      vars__.emplace_back(sigma_sq_free__);
      vars__.emplace_back(tau_sq_free__);
      for (int sym1__ = 1; sym1__ <= z_miss_1dim__; ++sym1__) {
        vars__.emplace_back(z_miss[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("beta");
    names__.emplace_back("phi");
    names__.emplace_back("sigma_sq");
    names__.emplace_back("tau_sq");
    names__.emplace_back("z_miss");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(p)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(z_miss_1dim__)
                                             });
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "phi");
    param_names__.emplace_back(std::string() + "sigma_sq");
    param_names__.emplace_back(std::string() + "tau_sq");
    for (int sym1__ = 1; sym1__ <= z_miss_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "z_miss" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "phi");
    param_names__.emplace_back(std::string() + "sigma_sq");
    param_names__.emplace_back(std::string() + "tau_sq");
    for (int sym1__ = 1; sym1__ <= z_miss_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "z_miss" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << p << "},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_sq\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"tau_sq\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"z_miss\",\"type\":{\"name\":\"array\",\"length\":" << z_miss_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << p << "},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_sq\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"tau_sq\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"z_miss\",\"type\":{\"name\":\"array\",\"length\":" << z_miss_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_gp_marginal_namespace::model_gp_marginal;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_gp_marginal_namespace::profiles__;
}
#endif
#endif
