% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_conditional_effects.R
\name{plot_conditional_effects.bgmfit}
\alias{plot_conditional_effects.bgmfit}
\alias{plot_conditional_effects}
\title{Visualize conditional effects of predictor}
\usage{
\method{plot_conditional_effects}{bgmfit}(
  model,
  effects = NULL,
  conditions = NULL,
  int_conditions = NULL,
  re_formula = NA,
  spaghetti = FALSE,
  surface = FALSE,
  categorical = FALSE,
  ordinal = FALSE,
  transform = NULL,
  resolution = 100,
  select_points = 0,
  too_far = 0,
  prob = 0.95,
  robust = TRUE,
  newdata = NULL,
  ndraws = NULL,
  draw_ids = NULL,
  levels_id = NULL,
  resp = NULL,
  ipts = 10,
  deriv = 0,
  deriv_model = NULL,
  idata_method = NULL,
  verbose = FALSE,
  dummy_to_factor = NULL,
  expose_function = FALSE,
  usesavedfuns = NULL,
  clearenvfuns = NULL,
  envir = NULL,
  ...
)

plot_conditional_effects(model, ...)
}
\arguments{
\item{model}{An object of class \code{bgmfit}.}

\item{effects}{An optional character vector naming effects (main effects or
interactions) for which to compute conditional plots. Interactions are
specified by a \code{:} between variable names. If \code{NULL} (the
default), plots are generated for all main effects and two-way interactions
estimated in the model. When specifying \code{effects} manually, \emph{all}
two-way interactions (including grouping variables) may be plotted
even if not originally modeled.}

\item{conditions}{An optional \code{data.frame} containing variable values
to condition on. Each effect defined in \code{effects} will
be plotted separately for each row of \code{conditions}. Values in the
\code{cond__} column will be used as titles of the subplots. If \code{cond__}
is not given, the row names will be used for this purpose instead.
It is recommended to only define a few rows in order to keep the plots clear.
See \code{\link[brms]{make_conditions}} for an easy way to define conditions.
If \code{NULL} (the default), numeric variables will be conditionalized by
using their means and factors will get their first level assigned.
\code{NA} values within factors are interpreted as if all dummy
variables of this factor are zero. This allows, for instance, to make
predictions of the grand mean when using sum coding.}

\item{int_conditions}{An optional named \code{list} whose elements are
vectors of values of the variables specified in \code{effects}.
At these values, predictions are evaluated. The names of
\code{int_conditions} have to match the variable names exactly.
Additionally, the elements of the vectors may be named themselves,
in which case their names appear as labels for the conditions in the plots.
Instead of vectors, functions returning vectors may be passed and are
applied on the original values of the corresponding variable.
If \code{NULL} (the default), predictions are evaluated at the
\eqn{mean} and at \eqn{mean +/- sd} for numeric predictors and at
all categories for factor-like predictors.}

\item{re_formula}{A formula containing group-level effects to be considered
in the conditional predictions. If \code{NULL}, include all group-level
effects; if \code{NA} (default), include no group-level effects.}

\item{spaghetti}{Logical. Indicates if predictions should
be visualized via spaghetti plots. Only applied for numeric
predictors. If \code{TRUE}, it is recommended
to set argument \code{ndraws} to a relatively small value
(e.g., \code{100}) in order to reduce computation time.}

\item{surface}{Logical. Indicates if interactions or
two-dimensional smooths should be visualized as a surface.
Defaults to \code{FALSE}. The surface type can be controlled
via argument \code{stype} of the related plotting method.}

\item{categorical}{Logical. Indicates if effects of categorical
or ordinal models should be shown in terms of probabilities
of response categories. Defaults to \code{FALSE}.}

\item{ordinal}{(Deprecated) Please use argument \code{categorical}.
Logical. Indicates if effects in ordinal models
should be visualized as a raster with the response categories
on the y-axis. Defaults to \code{FALSE}.}

\item{transform}{A function or a character string naming
a function to be applied on the predicted responses
before summary statistics are computed. Only allowed
if \code{method = "posterior_predict"}.}

\item{resolution}{Number of support points used to generate
the plots. Higher resolution leads to smoother plots.
Defaults to \code{100}. If \code{surface} is \code{TRUE},
this implies \code{10000} support points for interaction terms,
so it might be necessary to reduce \code{resolution}
when only few RAM is available.}

\item{select_points}{Positive number.
Only relevant if \code{points} or \code{rug} are set to \code{TRUE}:
Actual data points of numeric variables that
are too far away from the values specified in \code{conditions}
can be excluded from the plot. Values are scaled into
the unit interval and then points more than \code{select_points}
from the values in \code{conditions} are excluded.
By default, all points are used.}

\item{too_far}{Positive number.
For surface plots only: Grid points that are too
far away from the actual data points can be excluded from the plot.
\code{too_far} determines what is too far. The grid is scaled into
the unit square and then grid points more than \code{too_far}
from the predictor variables are excluded. By default, all
grid points are used. Ignored for non-surface plots.}

\item{prob}{A value between 0 and 1 indicating the desired probability
to be covered by the uncertainty intervals. The default is 0.95.}

\item{robust}{If \code{TRUE} (the default) the median is used as the
measure of central tendency. If \code{FALSE} the mean is used instead.}

\item{newdata}{An optional data frame to be used in estimation. If
\code{NULL} (default), the \code{newdata} is retrieved from the
\code{model}.}

\item{ndraws}{A positive integer indicating the number of posterior draws to
be used in estimation. If \code{NULL} (default), all draws are used.}

\item{draw_ids}{An integer indicating the specific posterior draw(s)
to be used in estimation (default \code{NULL}).}

\item{levels_id}{An optional argument to specify the \code{ids} for
hierarchical model (default \code{NULL}). It is used only when model is
applied to the data with 3 or more levels of hierarchy. For a two level
model, the \code{levels_id} is automatically inferred from the model fit.
Even for 3 or higher level model, the \code{levels_id} is inferred from the
model fit but under the assumption that hierarchy is specified from lowest
to upper most level i.e, \code{id} followed by \code{study} where \code{id}
is nested within the \code{study} Note that it is not guaranteed that the
\code{levels_id} is sorted correctly, and therefore it is better to set it
manually when fitting a model with three or more levels of hierarchy.}

\item{resp}{A character string (default \code{NULL}) to specify response
variable when processing posterior draws for the \code{univariate_by} and
\code{multivariate} models. See \code{\link[=bsitar]{bsitar()}} for details on
\code{univariate_by} and \code{multivariate} models}

\item{ipts}{An integer to set the length of the predictor variable to get a
smooth velocity curve. The \code{NULL} will return original values whereas
an integer such as \code{ipts = 10} (default) will interpolate the
predictor. It is important to note that these interpolations do not alter
the range of predictor when calculating population average and/or the
individual specific growth curves.}

\item{deriv}{An integer to indicate whether to estimate distance curve or its
derivative (i.e., velocity curve). The \code{deriv = 0} (default) is for
the distance curve whereas \code{deriv = 1} for the velocity curve.}

\item{deriv_model}{A logical to specify whether to estimate velocity curve
from the derivative function, or the differentiation of the distance curve.
The argument \code{deriv_model} is set to \code{TRUE} for those functions
which need velocity curve such as \code{growthparameters()} and
\code{plot_curves()}, and \code{NULL} for functions which explicitly use
the distance curve (i.e., fitted values) such as \code{loo_validation()}
and \code{plot_ppc()}.}

\item{idata_method}{A character string to indicate the interpolation method.
The number of of interpolation points is set up the \code{ipts} argument.
Options available for \code{idata_method} are \emph{method 1} (specified as
\code{'m1'}) and \emph{method 2} (specified as \code{'m2'}). The
\emph{method 1} (\code{'m1'}) is adapted from the the \pkg{iapvbs} package
and is documented here
\url{https://rdrr.io/github/Zhiqiangcao/iapvbs/src/R/exdata.R}
whereas \emph{method 2} (\code{'m2'}) is based on the \pkg{JMbayes}
package as documented here
\url{https://github.com/drizopoulos/JMbayes/blob/master/R/dynPred_lme.R}.
The \code{'m1'} method works by internally constructing the data frame based
on the model configuration whereas the method \code{'m2'} uses the exact
data frame used in model fit and can be accessed via \code{fit$data}. If
\code{idata_method = NULL, default}, then method \code{'m2'} is
automatically set. Note that method \code{'m1'} might fail in some cases
when model involves covariates particularly when model is fit as
\code{univariate_by}. Therefore, it is advised to switch to method
\code{'m2'} in case \code{'m1'} results in error.}

\item{verbose}{An optional argument (logical, default \code{FALSE}) to
indicate whether to print information collected during setting up the
object(s).}

\item{dummy_to_factor}{A named list (default \code{NULL}) that is used to
convert dummy variables into a factor variable. The named elements are
\code{factor.dummy}, \code{factor.name}, and \code{factor.level}. The
\code{factor.dummy} is a vector of character strings that need to be
converted to a factor variable whereas the \code{factor.name} is a single
character string that is used to name the newly created factor variable.
The \code{factor.level} is used to name the levels of newly created factor.
When \code{factor.name} is \code{NULL}, then the factor name is internally
set as \code{'factor.var'}. If \code{factor.level} is \code{NULL}, then
names of factor levels are take from the \code{factor.dummy} i.e., the
factor levels are assigned same name as \code{factor.dummy}. Note that when
\code{factor.level} is not \code{NULL}, its length must be same as the
length of the \code{factor.dummy}.}

\item{expose_function}{An optional logical argument to indicate whether to
expose Stan functions (default \code{FALSE}). Note that if user has already
exposed Stan functions during model fit by setting \code{expose_function =
  TRUE} in the \code{\link[=bsitar]{bsitar()}}, then those exposed functions are saved and can be
used during post processing of the posterior draws and therefore
\code{expose_function} is by default set as \code{FALSE} in all post
processing functions except \code{\link[=optimize_model]{optimize_model()}}. For \code{\link[=optimize_model]{optimize_model()}}, the
default setting is \code{expose_function = NULL}. The reason is that each
optimized model has different Stan function and therefore it need to be re
exposed and saved. The \code{expose_function = NULL} implies that the
setting for \code{expose_function} is taken from the original \code{model}
fit. Note that \code{expose_function} must be set to \code{TRUE} when
adding \code{fit criteria} and/or \code{bayes_R2} during model
optimization.}

\item{usesavedfuns}{A logical (default \code{NULL}) to indicate whether to
use the already exposed and saved \code{Stan} functions. Depending on
whether the user have exposed Stan functions within the \code{\link[=bsitar]{bsitar()}} call via
\code{expose_functions} argument in the \code{\link[=bsitar]{bsitar()}}, the \code{usesavedfuns}
is automatically set to \code{TRUE} (if \code{expose_functions = TRUE}) or
\code{FALSE} (if \code{expose_functions = FALSE}). Therefore, manual
setting of \code{usesavedfuns} as \code{TRUE}/\code{FALSE} is rarely
needed. This is for internal purposes only and mainly used during the
testing of the functions and therefore should not be used by users as it
might lead to unreliable estimates.}

\item{clearenvfuns}{A logical to indicate whether to clear the exposed
function from the environment (\code{TRUE}) or not (\code{FALSE}). If
\code{NULL} (default), then \code{clearenvfuns} is set as \code{TRUE} when
\code{usesavedfuns} is \code{TRUE}, and \code{FALSE} if \code{usesavedfuns}
is \code{FALSE}.}

\item{envir}{Environment used for function evaluation. The default is
\code{NULL} which will set \code{parent.frame()} as default environment.
Note that since most of post processing functions are based on \pkg{brms},
the functions needed for evaluation should be in the \code{.GlobalEnv}.
Therefore, it is strongly recommended to set \code{ envir = globalenv()}
(or \code{envir = .GlobalEnv}). This is particularly true for the
derivatives such as velocity curve.}

\item{...}{Additional arguments passed to the \code{\link[brms:conditional_effects.brmsfit]{brms::conditional_effects()}}
function. Please see \code{\link[brms:conditional_effects.brmsfit]{brms::conditional_effects()}} for details.}
}
\value{
An object of class 'brms_conditional_effects' which is a named list
with one data.frame per effect containing all information required to
generate conditional effects plots. See brms::conditional_effects for
details.
}
\description{
Display conditional effects of one or more numeric and/or categorical
predictors including two-way interaction effects.
}
\details{
The \strong{plot_conditional_effects()} is a wrapper around the
\code{\link[brms:conditional_effects.brmsfit]{brms::conditional_effects()}}. The \code{\link[brms:conditional_effects.brmsfit]{brms::conditional_effects()}} function
from the \pkg{brms} package can used to plot the fitted (distance) curve
when response (e.g., height) is not transformed. However, when the outcome
is log or square root transformed, the \code{\link[brms:conditional_effects.brmsfit]{brms::conditional_effects()}} will
return the fitted curve on the log or square root scale whereas the
\strong{plot_conditional_effects()} will return the fitted curve on the
original scale. Furthermore, the \strong{plot_conditional_effects()} also
plots the velocity curve on the original scale after making required
back-transformation. Apart from these differences, both these functions
(\link[brms:conditional_effects.brmsfit]{brms::conditional_effects} and \strong{plot_conditional_effects()} work
in the same manner. In other words, user can specify all the arguments
which are available in the \code{\link[brms:conditional_effects.brmsfit]{brms::conditional_effects()}}.
}
\examples{

# Fit Bayesian SITAR model 

# To avoid mode estimation which takes time, the Bayesian SITAR model fit to 
# the 'berkeley_exdata' has been saved as an example fit ('berkeley_exfit').
# See 'bsitar' function for details on 'berkeley_exdata' and 'berkeley_exfit'.

# Check and confirm whether model fit object 'berkeley_exfit' exists
 berkeley_exfit <- getNsObject(berkeley_exfit)

model <- berkeley_exfit

# Population average distance curve
plot_conditional_effects(model, deriv = 0, re_formula = NA)

\donttest{
# Individual-specific distance curves
plot_conditional_effects(model, deriv = 0, re_formula = NULL)

# Population average velocity curve
plot_conditional_effects(model, deriv = 1, re_formula = NA)

# Individual-specific velocity curves
plot_conditional_effects(model, deriv = 1, re_formula = NULL)
}

}
\seealso{
\code{\link[brms:conditional_effects.brmsfit]{brms::conditional_effects()}}
}
\author{
Satpal Sandhu  \email{satpal.sandhu@bristol.ac.uk}
}
