% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperparam.R, R/print-bvharspec.R, R/member.R
\name{set_ldlt}
\alias{set_ldlt}
\alias{set_sv}
\alias{print.covspec}
\alias{is.covspec}
\alias{is.svspec}
\alias{is.ldltspec}
\title{Covariance Matrix Prior Specification}
\usage{
set_ldlt(ig_shape = 3, ig_scl = 0.01)

set_sv(ig_shape = 3, ig_scl = 0.01, initial_mean = 1, initial_prec = 0.1)

\method{print}{covspec}(x, digits = max(3L, getOption("digits") - 3L), ...)

is.covspec(x)

is.svspec(x)

is.ldltspec(x)
}
\arguments{
\item{ig_shape}{Inverse-Gamma shape of Cholesky diagonal vector.
For SV (\code{\link[=set_sv]{set_sv()}}), this is for state variance.}

\item{ig_scl}{Inverse-Gamma scale of Cholesky diagonal vector.
For SV (\code{\link[=set_sv]{set_sv()}}), this is for state variance.}

\item{initial_mean}{Prior mean of initial state.}

\item{initial_prec}{Prior precision of initial state.}

\item{x}{Any object}

\item{digits}{digit option to print}

\item{...}{not used}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Set prior for covariance matrix.
}
\details{
\code{\link[=set_ldlt]{set_ldlt()}} specifies LDLT of precision matrix,
\deqn{\Sigma^{-1} = L^T D^{-1} L}

\code{\link[=set_sv]{set_sv()}} specifices time varying precision matrix under stochastic volatility framework based on
\deqn{\Sigma_t^{-1} = L^T D_t^{-1} L}
}
\references{
Carriero, A., Chan, J., Clark, T. E., & Marcellino, M. (2022). \emph{Corrigendum to “Large Bayesian vector autoregressions with stochastic volatility and non-conjugate priors” [J. Econometrics 212 (1)(2019) 137-154]}. Journal of Econometrics, 227(2), 506-512.

Chan, J., Koop, G., Poirier, D., & Tobias, J. (2019). \emph{Bayesian Econometric Methods (2nd ed., Econometric Exercises)}. Cambridge: Cambridge University Press.
}
