% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spillover.R, R/print-spillover.R
\name{spillover}
\alias{spillover}
\alias{print.bvharspillover}
\alias{knit_print.bvharspillover}
\alias{spillover.olsmod}
\alias{spillover.normaliw}
\alias{spillover.bvarldlt}
\alias{spillover.bvharldlt}
\title{h-step ahead Normalized Spillover}
\usage{
spillover(object, n_ahead = 10L, ...)

\method{print}{bvharspillover}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{knit_print}{bvharspillover}(x, ...)

\method{spillover}{olsmod}(object, n_ahead = 10L, ...)

\method{spillover}{normaliw}(
  object,
  n_ahead = 10L,
  num_iter = 5000L,
  num_burn = floor(num_iter/2),
  thinning = 1L,
  ...
)

\method{spillover}{bvarldlt}(object, n_ahead = 10L, level = 0.05, sparse = FALSE, ...)

\method{spillover}{bvharldlt}(object, n_ahead = 10L, level = 0.05, sparse = FALSE, ...)
}
\arguments{
\item{object}{Model object}

\item{n_ahead}{step to forecast. By default, 10.}

\item{...}{not used}

\item{x}{\code{bvharspillover} object}

\item{digits}{digit option to print}

\item{num_iter}{Number to sample MNIW distribution}

\item{num_burn}{Number of burn-in}

\item{thinning}{Thinning every thinning-th iteration}

\item{level}{Specify alpha of confidence interval level 100(1 - alpha) percentage. By default, .05.}

\item{sparse}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Apply restriction. By default, \code{FALSE}.}
}
\description{
This function gives connectedness table with h-step ahead normalized spillover index (a.k.a. variance shares).
}
\references{
Diebold, F. X., & Yilmaz, K. (2012). \emph{Better to give than to receive: Predictive directional measurement of volatility spillovers}. International Journal of forecasting, 28(1), 57-66.
}
