% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimators_weights.R
\name{calculateWeightsPLS}
\alias{calculateWeightsPLS}
\title{Calculate composite weights using PLS-PM}
\usage{
calculateWeightsPLS(
  .data                        = args_default()$.data,
  .S                           = args_default()$.S,
  .csem_model                  = args_default()$.csem_model,
  .conv_criterion              = args_default()$.conv_criterion,
  .iter_max                    = args_default()$.iter_max,
  .PLS_ignore_structural_model = args_default()$.PLS_ignore_structural_model,
  .PLS_modes                   = args_default()$.PLS_modes,
  .PLS_weight_scheme_inner     = args_default()$.PLS_weight_scheme_inner,
  .starting_values             = args_default()$.starting_values,
  .tolerance                   = args_default()$.tolerance
   )
}
\arguments{
\item{.data}{A \code{data.frame} or a \code{matrix} of standardized or unstandardized
data (indicators/items/manifest variables). Possible column types or classes
of the data provided are: "\code{logical}", "\code{numeric}" ("\code{double}" or "\code{integer}"),
"\code{factor}" ("\code{ordered}" and/or "\code{unordered}"), "\code{character}" (converted to factor),
or a mix of several types.}

\item{.S}{The (K x K) empirical indicator correlation matrix.}

\item{.csem_model}{A (possibly incomplete) \link{cSEMModel}-list.}

\item{.conv_criterion}{Character string. The criterion to use for the convergence check.
One of: "\emph{diff_absolute}", "\emph{diff_squared}", or "\emph{diff_relative}". Defaults
to "\emph{diff_absolute}".}

\item{.iter_max}{Integer. The maximum number of iterations allowed.
If \code{iter_max = 1} and \code{.approach_weights = "PLS-PM"} one-step weights are returned.
If the algorithm exceeds the specified number, weights of iteration step
\code{.iter_max - 1}  will be returned with a warning. Defaults to \code{100}.}

\item{.PLS_ignore_structural_model}{Logical. Should the structural model be ignored
when calculating the inner weights of the PLS-PM algorithm? Defaults to \code{FALSE}.
Ignored if \code{.approach_weights} is not PLS-PM.}

\item{.PLS_modes}{Either a named list specifying the mode that should be used for
each construct in the form \code{"construct_name" = mode}, a single character
string giving the mode that should be used for all constructs, or \code{NULL}.
Possible choices for \code{mode} are: "\emph{modeA}", "\emph{modeB}", "\emph{modeBNNLS}",
"\emph{unit}", "\emph{PCA}", a single integer or
a vector of fixed weights of the same length as there are indicators for the
construct given by \code{"construct_name"}. If only a single number is provided this is identical to
using unit weights, as weights are rescaled such that the related composite
has unit variance.  Defaults to \code{NULL}.
If \code{NULL} the appropriate mode according to the type
of construct used is chosen. Ignored if \code{.approach_weight} is not PLS-PM.}

\item{.PLS_weight_scheme_inner}{Character string. The inner weighting scheme
used by PLS-PM. One of: "\emph{centroid}", "\emph{factorial}", or "\emph{path}".
Defaults to "\emph{path}". Ignored if \code{.approach_weight} is not PLS-PM.}

\item{.starting_values}{A named list of vectors where the
list names are the construct names whose indicator weights the user
wishes to set. The vectors must be named vectors of \code{"indicator_name" = value}
pairs, where \code{value} is the (scaled or unscaled) starting weight. Defaults to \code{NULL}.}

\item{.tolerance}{Double. The tolerance criterion for convergence.
Defaults to \code{1e-05}.}
}
\value{
A named list. J stands for the number of constructs and K for the number
of indicators.
\describe{
\item{\verb{$W}}{A (J x K) matrix of estimated weights.}
\item{\verb{$E}}{A (J x J) matrix of inner weights.}
\item{\verb{$Modes}}{A named vector of modes used for the outer estimation.}
\item{\verb{$Conv_status}}{The convergence status. \code{TRUE} if the algorithm has converged
and \code{FALSE} otherwise. If one-step weights are used via \code{.iter_max = 1}
or a non-iterative procedure was used, the convergence status is set to \code{NULL}.}
\item{\verb{$Iterations}}{The number of iterations required.}
}
}
\description{
Calculate composite weights using the partial least squares path modeling
(PLS-PM) algorithm \insertCite{Wold1975}{cSEM}.
}
\references{
\insertAllCited{}
}
