% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cansim_sql.R
\name{csv2sqlite}
\alias{csv2sqlite}
\title{convert csv to sqlite
adapted from https://rdrr.io/github/coolbutuseless/csv2sqlite/src/R/csv2sqlite.R}
\usage{
csv2sqlite(
  csv_file,
  sqlite_file,
  table_name,
  transform = NULL,
  chunk_size = 5e+06,
  append = FALSE,
  col_types = NULL,
  na = c(NA, "..", "", "...", "F"),
  text_encoding = "UTF-8",
  delim = ",",
  ...
)
}
\arguments{
\item{csv_file}{input csv path}

\item{sqlite_file}{output sql database path}

\item{table_name}{sql table name}

\item{transform}{optional function that transforms each chunk}

\item{chunk_size}{optional chunk size to read/write data, default=1,000,000}

\item{append}{optional parameter, append to database or overwrite, defaul=`FALSE`}

\item{col_types}{optional parameter for csv column types}

\item{na}{na character strings}

\item{text_encoding}{encoding of csv file (default UTF-8)}

\item{delim}{(Optional) csv deliminator, default is ","}

\item{...}{(Optional) additional parameters passed to `readr::read_delim_chunked`}
}
\value{
A database connection
}
\description{
convert csv to sqlite
adapted from https://rdrr.io/github/coolbutuseless/csv2sqlite/src/R/csv2sqlite.R
}
\keyword{internal}
