% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_singlescan.R
\name{plot_singlescan}
\alias{plot_singlescan}
\title{Plot results of single-locus scans}
\usage{
plot_singlescan(
  data_obj,
  singlescan_obj,
  chr = NULL,
  traits = NULL,
  alpha = c(0.01, 0.05),
  standardized = TRUE,
  color_scheme = c("DO/CC", "other"),
  allele_labels = NULL,
  include_covars = TRUE,
  show_selected = FALSE,
  line_type = "l",
  lwd = 1,
  pch = 16,
  cex = 1,
  covar_label_size = 0.7
)
}
\arguments{
\item{data_obj}{a \code{\link{Cape}} object}

\item{singlescan_obj}{a singlescan object from \code{\link{singlescan}}}

\item{chr}{a vector of chromosome names to include in the plot. Defaults to all chromosomes.}

\item{traits}{a vector of trait names to plot. Defaults to all traits.}

\item{alpha}{the alpha significance level. Lines for significance values will only
be plotted if n_perm > 0 when \code{\link{singlescan}} was run. And only alpha values
specified in \code{\link{singlescan}} can be plotted.}

\item{standardized}{If TRUE t statistics are plotted. If FALSE, effect sizes are plotted.}

\item{color_scheme}{A character value of either "DO/CC" or other indicating the 
color scheme of main effects. If "DO/CC" allele effects can be plotted with the
DO/CC colors.}

\item{allele_labels}{A vector of labels for the alleles if different than those
stored in the data_object.}

\item{include_covars}{Whether to include covariates in the plot.}

\item{show_selected}{If TRUE will indicate which markers were selected for the pairscan.
In order for these to be plotted, \code{\link{select_markers_for_pairscan}} must be run first.}

\item{line_type}{as defined in plot}

\item{lwd}{line width, default is 1}

\item{pch}{see the "points()" R function. Default is 16 (a point).}

\item{cex}{see the "points()" R function. Default is 1.}

\item{covar_label_size}{default is 0.7}
}
\description{
This function plots the results of \code{\link{singlescan}}
}
