% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uri_functions.R
\name{.rtweet}
\alias{.rtweet}
\alias{carbon-rtweet}
\title{send tweets using carbonate outputs}
\usage{
.rtweet(self, private, media, status = self$tweet_status,
  media_format = c("png", "gif"), ...)
}
\arguments{
\item{self}{carbon self object}

\item{private}{carbon private object}

\item{media}{magick-image object or path to image}

\item{status}{character, status to attach to post, Default: self$tweet_status}

\item{media_format}{character, type of media to tweet, Default: c('png','gif')}

\item{\dots}{arguments to pass to \link[rtweet:post_tweet]{post_tweet}}
}
\value{
outcome from rtweet
}
\description{
wrapper for \link[rtweet:post_tweet]{post_tweet} to send
tweets with media created using carbonate.
}
\details{
If multiple images are passed they can be either converted to a gif by
setting media_format to 'gif' or attached each one to the post.
}
\examples{
\dontrun{
x <- carbonate::carbon$new()
x$carbonate(code = readLines(system.file('DESCRIPTION',package='carbonate')))
x$carbonate(code = 'x+2')

# using default status value (x$tweet_status)
x$rtweet(system.file('figures/hex_black_small.png',package='carbonate'))

x$rtweet(status = 'these are two pngs',media = x$carbons,media_format='png')
x$rtweet(status = 'this is a gif', media = x$carbons,media_format='gif')

}
}
\seealso{
\link[magick:editing]{image_write}
\link[rtweet:post_tweet]{post_tweet}
}
