% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_identity.R
\name{ard_identity}
\alias{ard_identity}
\title{ARD Identity}
\usage{
ard_identity(x, variable, context = "identity")
}
\arguments{
\item{x}{(named \code{list}/\code{data.frame})\cr
named list of results or a data frame.
Names are the statistic names, and the values
are the statistic values. These comprise the \code{"stat_name"} and \code{"stat"}
columns in the returned ARD.}

\item{variable}{(\code{string})\cr
string of a variable name that is assigned to the \code{"variable"} column in the
ARD.}

\item{context}{(\code{string})\cr
string to be added to the \code{"context"} column. Default is \code{"identity"}.}
}
\value{
a ARD
}
\description{
Function ingests pre-calculated statistics and returns the identical results,
but in an ARD format.
}
\examples{
t.test(formula = AGE ~ 1, data = ADSL)[c("statistic", "parameter", "p.value")] |>
  ard_identity(variable = "AGE", context = "onesample_t_test")
}
