% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_categorical_ci.survey.design.R
\name{ard_categorical_ci.survey.design}
\alias{ard_categorical_ci.survey.design}
\title{ARD survey categorical CIs}
\usage{
\method{ard_categorical_ci}{survey.design}(
  data,
  variables,
  by = NULL,
  method = c("logit", "likelihood", "asin", "beta", "mean", "xlogit"),
  conf.level = 0.95,
  value = list(where(is_binary) ~ 1L, where(is.logical) ~ TRUE),
  df = survey::degf(data),
  ...
)
}
\arguments{
\item{data}{(\code{survey.design})\cr
a design object often created with \code{\link[survey:svydesign]{survey::svydesign()}}.}

\item{variables}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
columns to include in summaries.}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
results are calculated for \strong{all combinations} of the columns specified,
including unobserved combinations and unobserved factor levels.}

\item{method}{(\code{string})\cr
Method passed to \code{survey::svyciprop(method)}}

\item{conf.level}{(\code{numeric})\cr
a scalar in \verb{(0, 1)} indicating the confidence level.
Default is \code{0.95}}

\item{value}{(\code{\link[cards:syntax]{formula-list-selector}})\cr
function will calculate the CIs for all levels of the variables specified.
Use this argument to instead request only a single level by summarized.
Default is \code{list(where(is_binary) ~ 1L, where(is.logical) ~ TRUE)}, where
columns coded as \code{0}/\code{1} and \code{TRUE}/\code{FALSE} will summarize the \code{1} and \code{TRUE} levels.}

\item{df}{(\code{numeric})\cr
denominator degrees of freedom, passed to \code{survey::svyciprop(df)}.
Default is \code{survey::degf(data)}.}

\item{...}{arguments passed to \code{survey::svyciprop()}}
}
\value{
ARD data frame
}
\description{
Confidence intervals for categorical variables calculated via
\code{\link[survey:svyciprop]{survey::svyciprop()}}.
}
\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = "survey", reference_pkg = "cardx"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(api, package = "survey")
dclus1 <- survey::svydesign(id = ~dnum, weights = ~pw, data = apiclus1, fpc = ~fpc)

ard_categorical_ci(dclus1, variables = sch.wide)
ard_categorical_ci(dclus1, variables = sch.wide, value = sch.wide ~ "Yes", method = "xlogit")
\dontshow{\}) # examplesIf}
}
