% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_survival_survfit.R
\name{ard_survival_survfit}
\alias{ard_survival_survfit}
\alias{ard_survival_survfit.survfit}
\alias{ard_survival_survfit.data.frame}
\title{ARD Survival Estimates}
\usage{
ard_survival_survfit(x, ...)

\method{ard_survival_survfit}{survfit}(x, times = NULL, probs = NULL, type = NULL, ...)

\method{ard_survival_survfit}{data.frame}(
  x,
  y,
  variables,
  times = NULL,
  probs = NULL,
  type = NULL,
  method.args = list(conf.int = 0.95),
  ...
)
}
\arguments{
\item{x}{(\code{survfit} or \code{data.frame})\cr
an object of class \code{survfit} created with \code{\link[survival:survfit]{survival::survfit()}} or a data frame. See below for details.}

\item{...}{These dots are for future extensions and must be empty.}

\item{times}{(\code{numeric})\cr
a vector of times for which to return survival probabilities.}

\item{probs}{(\code{numeric})\cr
a vector of probabilities with values in (0,1) specifying the survival quantiles to return.}

\item{type}{(\code{string} or \code{NULL})\cr
type of statistic to report. Available for Kaplan-Meier time estimates only, otherwise \code{type}
is ignored. Default is \code{NULL}.
Must be one of the following:\tabular{ll}{
   type \tab transformation \cr
   \code{"survival"} \tab \code{x} \cr
   \code{"risk"} \tab \code{1 - x} \cr
   \code{"cumhaz"} \tab \code{-log(x)} \cr
}}

\item{y}{(\code{Surv} or \code{string})\cr
an object of class \code{Surv} created using \code{\link[survival:Surv]{survival::Surv()}}. This object will be passed as the left-hand side of
the formula constructed and passed to \code{\link[survival:survfit]{survival::survfit()}}. This object can also be passed as a string.}

\item{variables}{(\code{character})\cr
stratification variables to be passed as the right-hand side of the formula constructed and passed to
\code{\link[survival:survfit]{survival::survfit()}}.}

\item{method.args}{(named \code{list})\cr
named list of arguments that will be passed to \code{\link[survival:survfit]{survival::survfit()}}.}
}
\value{
an ARD data frame of class 'card'
}
\description{
Analysis results data for survival quantiles and x-year survival estimates, extracted
from a \code{\link[survival:survfit]{survival::survfit()}} model.
}
\details{
\itemize{
\item Only one of either the \code{times} or \code{probs} parameters can be specified.
\item Times should be provided using the same scale as the time variable used to fit the provided
survival fit model.
}
}
\section{Formula Specification}{

When passing a \code{\link[survival:survfit]{survival::survfit()}} object to \code{ard_survival_survfit()},
the \code{survfit()} call must use an evaluated formula and not a stored formula.
Including a proper formula in the call allows the function to accurately
identify all variables included in the estimation. See below for examples:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(cardx)
library(survival)

# include formula in `survfit()` call
survfit(Surv(time, status) ~ sex, lung) |> ard_survival_survfit(time = 500)

# you can also pass a data frame to `ard_survival_survfit()` as well.
lung |>
  ard_survival_survfit(y = Surv(time, status), variables = "sex", time = 500)
}\if{html}{\out{</div>}}

You \strong{cannot}, however, pass a stored formula, e.g. \code{survfit(my_formula, lung)},
but you can use stored formulas with \code{rlang::inject(survfit(!!my_formula, lung))}.
}

\section{Variable Classes}{

When the \code{survfit} method is called, the class of the stratifying variables
will be returned as a factor.

When the data frame method is called, the original classes are retained in the
resulting ARD.
}

\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = c("survival", "broom", "ggsurvfit")))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(survival)
library(ggsurvfit)

survfit(Surv_CNSR(AVAL, CNSR) ~ TRTA, data = cards::ADTTE) |>
  ard_survival_survfit(times = c(60, 180))

survfit(Surv_CNSR(AVAL, CNSR) ~ TRTA, data = cards::ADTTE, conf.int = 0.90) |>
  ard_survival_survfit(probs = c(0.25, 0.5, 0.75))

cards::ADTTE |>
  ard_survival_survfit(y = Surv_CNSR(AVAL, CNSR), variables = c("TRTA", "SEX"), times = 90)

# Competing Risks Example ---------------------------
set.seed(1)
ADTTE_MS <- cards::ADTTE \%>\%
  dplyr::mutate(
    CNSR = dplyr::case_when(
      CNSR == 0 ~ "censor",
      runif(dplyr::n()) < 0.5 ~ "death from cancer",
      TRUE ~ "death other causes"
    ) \%>\% factor()
  )

survfit(Surv(AVAL, CNSR) ~ TRTA, data = ADTTE_MS) \%>\%
  ard_survival_survfit(times = c(60, 180))
\dontshow{\}) # examplesIf}
}
