% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waffleLayer.R
\name{waffleLayer}
\alias{waffleLayer}
\title{Waffle Layer}
\usage{
waffleLayer(
  x,
  var,
  cellvalue,
  cellsize,
  cellrnd = "ceiling",
  celltxt = paste0("1 cell = ", cellvalue),
  labels,
  ncols,
  col,
  border = "white",
  lwd = 0.2,
  legend.pos = "bottomleft",
  legend.title.txt = "legend title",
  legend.title.cex = 0.8,
  legend.values.cex = 0.6,
  legend.frame = FALSE,
  add = TRUE
)
}
\arguments{
\item{x}{an sf object, a simple feature collection.}

\item{var}{names of the numeric variable to plot.}

\item{cellvalue}{value of a single cell. Original values are rounded, using
\code{cellrnd} method, to be expressed as multiple of \code{cellvalue}.}

\item{cellsize}{size of single cell, in map units.}

\item{cellrnd}{rounding method, one of "ceiling", "floor", "round".}

\item{celltxt}{text that appears under the legend.}

\item{labels}{names that will appear in the legend.}

\item{ncols}{number of columns of the waffles}

\item{col}{a vector of colors.}

\item{border}{color of the cells borders.}

\item{lwd}{cells borders width.}

\item{legend.pos}{position of the legend, one of "topleft", "top", 
"topright", "right", "bottomright", "bottom", "bottomleft", "left" or a 
vector of two coordinates in map units (c(x, y)). If 
legend.pos is "n" then the legend is not plotted.}

\item{legend.title.txt}{title of the legend.}

\item{legend.title.cex}{size of the legend title.}

\item{legend.values.cex}{size of the values in the legend.}

\item{legend.frame}{whether to add a frame to the legend (TRUE) or 
not (FALSE).}

\item{add}{whether to add the layer to an existing plot (TRUE) or 
not (FALSE).}
}
\description{
Plot a waffle layer.
}
\examples{
library(sf)
mtq <- st_read(system.file("gpkg/mtq.gpkg", package = "cartography"),
               quiet = TRUE)
# number of employed persons
mtq$EMP <- mtq$ACT - mtq$CHOM

plot(st_geometry(mtq),
     col = "#f2efe9",
     border = "#b38e43",
     lwd = 0.5)
waffleLayer(
  x = mtq,
  var = c("EMP", "CHOM"),
  cellvalue = 100,
  cellsize = 400,
  cellrnd = "ceiling",
  celltxt = "1 cell represents 100 persons",
  labels = c("Employed", "Unemployed"),
  ncols = 6,
  col = c("tomato1", "lightblue"),
  border = "#f2efe9",
  legend.pos = "topright",
  legend.title.cex = 1,
  legend.title.txt = "Active Population",
  legend.values.cex = 0.8,
  add = TRUE
)

layoutLayer(
  title = "Structure of the Active Population",
  col = "tomato4",
  tabtitle = TRUE,
  scale = FALSE,
  sources =  paste0("cartography ", packageVersion("cartography")),
  author = "Sources: Insee and IGN, 2018",
)
}
