% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomics_by_sample.R
\name{get_segments_by_sample}
\alias{get_segments_by_sample}
\title{Get Copy Number Segmentation Data By Sample ID}
\usage{
get_segments_by_sample(
  sample_id = NULL,
  study_id = NULL,
  sample_study_pairs = NULL,
  base_url = NULL
)
}
\arguments{
\item{sample_id}{a vector of sample IDs (character)}

\item{study_id}{A string indicating the study ID from which to pull data. If no study ID, will
guess the study ID based on your URL and inform. Only 1 study ID can be passed. If mutations/cna from
more than 1 study needed, see \code{sample_study_pairs}}

\item{sample_study_pairs}{A dataframe with columns: \code{sample_id}, \code{study_id} and \code{molecular_profile_id} (optional). Variations in capitalization of column names are accepted.
This can be used in place of \code{sample_id}, \code{study_id}, \code{molecular_profile_id} arguments above if you
need to pull samples from several different studies at once. If passed this will take overwrite \code{sample_id}, \code{study_id}, \code{molecular_profile_id} if also passed.}

\item{base_url}{The database URL to query
If \code{NULL} will default to URL set with \verb{set_cbioportal_db(<your_db>)}}
}
\value{
A dataframe of CNA segments
}
\description{
Get Copy Number Segmentation Data By Sample ID
}
\examples{
\dontrun{
set_cbioportal_db("public")

get_segments_by_sample(sample_id = c("s_C_CAUWT7_P001_d"),
                 study_id = "prad_msk_2019")
                 }
}
