% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotEncoding.R
\name{plotComponent}
\alias{plotComponent}
\title{Plot Components}
\usage{
plotComponent(
  x,
  comp = c(1, 2),
  addNames = TRUE,
  nudge_x = 0.1,
  nudge_y = 0.1,
  size = 4,
  ...
)
}
\arguments{
\item{x}{output of \code{\link{compute_optimal_encoding}} function}

\item{comp}{a vector of two elements indicating the components to plot}

\item{addNames}{if TRUE, add the id labels on the plot}

\item{nudge_x, nudge_y}{horizontal and vertical adjustment to nudge labels by}

\item{size}{size of labels}

\item{...}{\code{geom_point} parameters}
}
\value{
a \code{ggplot} object that can be modified using \code{ggplot2} package.
}
\description{
Plot Components
}
\examples{
# Simulate the Jukes-Cantor model of nucleotide replacement
K <- 4
Tmax <- 6
PJK <- matrix(1 / 3, nrow = K, ncol = K) - diag(rep(1 / 3, K))
lambda_PJK <- c(1, 1, 1, 1)
d_JK <- generate_Markov(n = 10, K = K, P = PJK, lambda = lambda_PJK, Tmax = Tmax)
d_JK2 <- cut_data(d_JK, Tmax)

# create basis object
m <- 6
b <- create.bspline.basis(c(0, Tmax), nbasis = m, norder = 4)
\donttest{
# compute encoding
encoding <- compute_optimal_encoding(d_JK2, b, computeCI = FALSE, nCores = 1)

plotComponent(encoding, comp = c(1, 2))

# modify the plot using ggplot2
library(ggplot2)
plotComponent(encoding, comp = c(1, 2), shape = 23) +
  labs(title = "Two first components")
}


}
\seealso{
Other encoding functions: 
\code{\link{compute_optimal_encoding}()},
\code{\link{get_encoding}()},
\code{\link{plot.fmca}()},
\code{\link{plotEigenvalues}()},
\code{\link{predict.fmca}()},
\code{\link{print.fmca}()},
\code{\link{summary.fmca}()}
}
\author{
Quentin Grimonprez
}
\concept{encoding functions}
