% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chatRater.R
\name{generate_ratings_for_all}
\alias{generate_ratings_for_all}
\title{Generate ratings for all stims using LLM}
\usage{
generate_ratings_for_all(
  model = "gpt-3.5-turbo",
  stim_list,
  prompt = "...",
  question = "...",
  top_p = 1,
  temp = 0,
  n_iterations = 30,
  api_key = "",
  debug = FALSE
)
}
\arguments{
\item{model}{A character string specifying the LLM model to use.}

\item{stim_list}{A character vector of stims (e.g., idioms) for which ratings will be generated.}

\item{prompt}{A character string providing context or an identity for LLM (e.g., "You are a native English speaker.").}

\item{question}{A character string that provides instructions for LLM.}

\item{top_p}{A numeric value limiting token selection to a probability mass.}

\item{temp}{A numeric value specifying the temperature for the API call.}

\item{n_iterations}{An integer indicating the number of times to query LLM for each stim.}

\item{api_key}{Your OpenAI API key.}

\item{debug}{Logical, whether to run in debug mode. Defaults to FALSE.}
}
\value{
A data frame containing the stim, rating, and iteration number for each API call.
}
\description{
This function iterates over a vector of stims (e.g., idioms) and generates ratings for each
by calling the \code{generate_ratings} function. It aggregates all results into a single data frame.
}
\examples{
\dontrun{
  generate_ratings_for_all(model = "gpt-3.5-turbo",
                           stim_list = c("kick the bucket", "spill the beans"),
                           prompt = "You are a native English speaker.",
                           question = "Please rate the following stim:",
                           top_p = 1,
                           temp = 0,
                           n_iterations = 30,
                           api_key = "your_api_key",
                           debug = TRUE)
}
}
