% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_frame.R
\name{new_df}
\alias{new_df}
\alias{as_df}
\alias{fast_df}
\alias{list_as_df}
\alias{name_repair}
\alias{unique_name_repair}
\alias{col_c}
\alias{row_c}
\title{Cheap data frame utilities}
\usage{
new_df(..., .nrows = NULL, .recycle = TRUE, .name_repair = TRUE, .args = NULL)

as_df(x)

fast_df(..., .args = NULL)

list_as_df(x)

name_repair(x, dup_sep = "_", empty_sep = "col_")

unique_name_repair(x, dup_sep = "_", empty_sep = "col_")

col_c(..., .recycle = TRUE, .name_repair = TRUE, .args = NULL)

row_c(..., .args = NULL)
}
\arguments{
\item{...}{Key-value pairs.}

\item{.nrows}{\verb{[integer(1)]} - (Optional) number of rows. \cr
Commonly used to initialise a 0-column data frame with rows.}

\item{.recycle}{\verb{[logical(1)]} - Should arguments be recycled?
Default is \code{TRUE}.}

\item{.name_repair}{\verb{[logical(1)]} - Should duplicate and empty names
repaired and made unique? Default is \code{TRUE}.}

\item{.args}{An alternative to \code{...} for easier programming with lists.}

\item{x}{An object to coerce to a \code{data.frame} or a character vector
for \code{unique_name_repair()}.}

\item{dup_sep}{\verb{[character(1)]} A separator to use between
duplicate column names and their locations. Default is \code{'_'}}

\item{empty_sep}{\verb{[character(1)]} A separator to use between the empty
column names and their locations. Default is \code{'col_'}}
}
\value{
A \code{data.frame}. \cr
\code{name_repair} takes a character vector and returns unique strings by
appending duplicate string locations to the duplicates.
This is mostly used to create unique col names.
}
\description{
Cheap data frame utilities
}
\details{
\code{fast_df()} is a very fast bare-bones version of \code{new_df()} that
performs no checks and no recycling or name tidying, making it appropriate
for very tight loops.
}
