% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/task_spec.R
\name{check_task_spec}
\alias{check_task_spec}
\title{Create a task to run \verb{R CMD check}}
\usage{
check_task_spec(
  args = options::opt("check_args"),
  build_args = options::opt("check_build_args"),
  ...
)
}
\arguments{
\item{args}{Character vector of arguments to pass to \verb{R CMD check}. Pass each
argument as a single element of this character vector (do not use spaces to
delimit arguments like you would in the shell). For example, to skip
running of examples and tests, use \code{args = c("--no-examples", "--no-tests")} and not \code{args = "--no-examples --no-tests"}. (Note that
instead of the \code{--output} option you should use the \code{check_dir} argument,
because  \code{--output} cannot deal with spaces and other special characters on
Windows.)}

\item{build_args}{Character vector of arguments to pass to \verb{R CMD build}.
Pass each argument as a single element of this character vector (do not use
spaces to delimit arguments like you would in the shell). For example,
\code{build_args = c("--force", "--keep-empty-dirs")} is a correct usage and
\code{build_args = "--force --keep-empty-dirs"} is incorrect.}

\item{...}{
  Arguments passed on to \code{\link[=task_spec]{task_spec}}
  \describe{
    \item{\code{alias}}{task alias which also serves as unique identifier of the task.}
    \item{\code{package_spec}}{\code{\link[checked]{package_spec}} object}
    \item{\code{env}}{environmental variables to be set in separate process running
specific task.}
  }}
}
\description{
Create a task to run \verb{R CMD check}
}
\seealso{
Other tasks: 
\code{\link{checked-task-df}},
\code{\link{custom_install_task_spec}()},
\code{\link{install_task_spec}()},
\code{\link{rev_dep_check_tasks_df}()},
\code{\link{revdep_check_task_spec}()},
\code{\link{source_check_tasks_df}()},
\code{\link{task_spec}()}
}
\concept{tasks}
