% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temperature_scenario_baseline_adjustment.R
\name{temperature_scenario_baseline_adjustment}
\alias{temperature_scenario_baseline_adjustment}
\title{Make temperature scenario relative to a particular baseline}
\usage{
temperature_scenario_baseline_adjustment(
  baseline_temperature_scenario,
  temperature_scenario,
  temperature_check_args = NULL,
  warn_me = TRUE,
  required_variables = c("Tmin", "Tmax")
)
}
\arguments{
\item{baseline_temperature_scenario}{baseline temperature scenario (e.g. produced with
'extract_temperatures_from_grids'). This is a temperature scenario object, consisting of the
following elements: 'data' = data.frame with two columns Tmin and Tmax containing absolute
(normally monthly) mean minimum and maximum temperatures; 'reference_year' = the year the scenario
refers to (this is normally NA for absolute temperature scenarios, because they don't require
considering a reference scenario); 'scenario_type' = the scenario type, normally "absolute" (but can
also be "relative" or NA - then the type is automatically assigned); 'labels' = elements
attached to the input temperature_scenario. A subset of these elements can
also be specified, but 'data' must be present.}

\item{temperature_scenario}{can be one of three options:
1) a data.frame with two columns Tmin and Tmax and n_intervals (default: 12) rows containing
temperature changes for all time intervals, or absolute temperatures for these intervals.
2) a temperature scenario object, consisting of the following elements: 'data' = a data frame with
n_intervals elements containing the absolute or relative temperature information (as in input option 1);
'scenario_year' = the year the scenario is representative of; 'reference_year' = the year the
scenario is representative of; 'scenario_type' = the scenario type ('absolute' or 'relative' - if
NA, this is assigned automatically); 'labels' = and elements attached to the input
temperature_scenario as an element names 'labels'. A subset of these elements can also be specified,
but 'data' must be present.
3) a list of elements of type 1 or 2. Then the adjustment is done for all elements.}

\item{temperature_check_args}{list of arguments to be passed to the check_temperature_scenario function.
Check documentation of that function for details.}

\item{warn_me}{boolean variable specifying whether warnings should be shown. Defaults to TRUE.}

\item{required_variables}{character vectors containing names of variables that must be included in the
scenario.}
}
\value{
temperature scenario object, consisting of the following elements: 'data' = a data frame with
n_intervals elements containing the absolute or relative temperature information. 'reference_year' =
the year the scenario is representative of. 'scenario_type' = the scenario type ('absolute' or 'relative');
'labels' = and elements attached to the input temperature_scenario as an element names 'labels'.

The function also returns warnings, where elements are missing or the scenario_type appears to be
wrong, and it stops with an error, if the scenario isn't specified in a format that is usable by
chillR.
}
\description{
When interpreting future (or past) temperature scenarios that provide absolute temperatures,
it is important to consider the temperature baseline, i.e. a temperature scenario produced with
similar models and methods that corresponds to the current temperature regime. Such baselines are
normally available from the same source that provided the future scenarios. This function implements
this adjustment.
The function can be used for two situations:
1) two absolute temperature scenarios: the output is the difference between the scenarios, i.e.
a relative temperature scenario describing the difference between monthly temperature extreme
means between the two scenarios.
2) two relative temperature scenarios: the output is a relative temperature scenario that describes
the difference between the scenario year of the temperature_scenario and the baseline year of the
baseline_temperature_scenario. This only works if the scenario_year of the baseline_temperature_scenario
is the same as the reference_year of the temperature_scenario.
}
\examples{

baseline_temperature_scenario<-list(data=data.frame(Tmin=c(1,1,1,1,1,1,1,1,1,1,1,1),
                                                    Tmax=c(1,1,1,1,1,1,1,1,1,1,1,1)),
                                                    scenario_year=1990,
                                                    reference_year=1975,
                                                    scenario_type="relative")
                                                    
temperature_scenario<-list(data=data.frame(Tmin=c(4,4,4,4,4,4,4,4,4,4,4,4),
                                           Tmax=c(4,4,4,4,4,4,4,4,4,4,4,4)),
                                           scenario_year=2000,
                                           reference_year=1990,
                                           scenario_type="relative")
                                           
relative_temperature_scenario<-temperature_scenario_baseline_adjustment(
                     baseline_temperature_scenario,temperature_scenario,
                     temperature_check_args=NULL)
                                                                       
baseline_temperature_scenario<-list(data=data.frame(Tmin=c(-5,-2,2,5,10,12,15,15,12,10,5,1),
                                                    Tmax=c( 1, 4,7,10,15,18,22,24,17,15,11,6)),
                                                    scenario_year=1980,
                                                    reference_year=NA,
                                                    scenario_type="absolute")
                                                    
temperature_scenario<-list(data=data.frame(Tmin=c(-3,0,4,7,12,14,17,17,14,12,7,3),
                                                    Tmax=c(3,6,9,12,17,20,24,26,19,17,13,8)),
                                           scenario_year=2000,
                                           reference_year=NA,
                                           scenario_type="absolute")
                                           
relative_temperature_scenario<-temperature_scenario_baseline_adjustment(
                     baseline_temperature_scenario,temperature_scenario,
                     temperature_check_args=NULL)
                                            
 
}
\author{
Eike Luedeling
}
\keyword{utility}
