% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsers.R
\name{uv_converter}
\alias{uv_converter}
\title{Converter for Agilent ChemStation UV files}
\usage{
uv_converter(
  file,
  format_out = c("matrix", "data.frame"),
  correction = TRUE,
  read_metadata = TRUE
)
}
\arguments{
\item{file}{path to file}

\item{format_out}{R format. Either \code{matrix} or \code{data.frame}.}

\item{correction}{Logical. Whether to apply empirical correction. Defaults is
TRUE.}

\item{read_metadata}{Logical. Whether to read metadata and attach it to the
chromatogram.}
}
\value{
A chromatogram in \code{data.frame} format (retention time x wavelength).
}
\description{
Converts a single chromatogram from ChemStation \code{.uv} format to R \code{data.frame}.
}
\details{
Uses the \href{https://github.com/bovee/aston}{Aston} file parser.
}
