% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.r
\name{plot.DRtrace}
\alias{plot.DRtrace}
\alias{plot.doseResponse}
\title{Plotting Methods for DRtrace, doseResponse Objects}
\usage{
\method{plot}{DRtrace}(
  x,
  xlab = "Patient Order",
  ylab = "Dose",
  shape = "circle",
  connect = TRUE,
  mcol = 1,
  dosevals = NULL,
  offset = 0.2,
  ...
)

\method{plot}{doseResponse}(
  x,
  xlab = "Dose",
  ylab = "Response",
  pch = "X",
  varsize = TRUE,
  refsize = sqrt(1/mean(x$weight)),
  connect = FALSE,
  mcol = 1,
  dosevals = NULL,
  ...
)
}
\arguments{
\item{x}{the object, whether DRtrace or doseResponse}

\item{xlab, ylab}{x-axis and y-axis labels passed on to \code{\link{plot}}}

\item{shape}{the plotting shape (DRtrace only): 'circle' (default), 'square', or 'triangle'}

\item{connect}{logical: whether to connect the symbols (generic plotting type 'b'). Default \code{TRUE} for \code{\link{DRtrace}} and \code{FALSE} for \code{\link{doseResponse}}}

\item{mcol}{The color of the main plotting symbols and connecting lines. Default 1 (the current palette's first color). Note: if you change the color and inadvertently use \code{col} instead, there will be an error message.}

\item{dosevals}{Dose values to be plotted along the x-axis (\code{plot.doseResponse}) or y-axis (\code{plot.DRtrace}) . If \code{NULL} (default), those will be the doses in the dataset (i.e.,\code{sort(unique(x$x))}).}

\item{offset}{(\code{DRtrace} only) In case of a cohort-based experiment, the relative vertical offset between symbols for outcomes within the same cohort (as fraction of dose spacing). Default 0.2.}

\item{...}{Other arguments passed on to \code{\link{plot}}.

Conversely, putting values on a different scale into \code{dosevals}, or even text labels instead of numbers, won't work. For the former, change the scale at the source data (i.e., in the plotted object). For the latter, sorry but no solution at present.}

\item{pch}{the plotting character (doseResponse only), the default being 'X' marks}

\item{varsize}{(\code{doseResponse} only) logical, should symbol size vary by sample size? Default \code{TRUE}}

\item{refsize}{(\code{doseResponse} only) a reference size by which the plotting sizes will be multiplied. Default is \code{1/sqrt(mean(dr$weight))}, scaled so that if \code{varsize = TRUE} the weighted-average symbol size is 1. If \code{varsize = FALSE}, this argument is equivalent to \code{cex} in an ordinary x-y \code{plot()} call.}
}
\description{
Plotting methods for \code{\link{doseResponse}} and \code{\link{DRtrace}} classes.
}
\details{
Generic methods for dose-response trajectory/trace (\code{\link{DRtrace}}), and dose-response summary  (\code{\link{doseResponse}}) class objects.
The \code{\link{DRtrace}} plotting uses the typical convention of plotting dose-finding experimental trace, with dose levels (x) in the vertical axis and 1/0 responses (y) denoted via filled/empty circles, respectively. In other words, this generic plotting method is only relevant for binary 0/1 outcomes.
The \code{\link{doseResponse}} plotting has response rate on the y-axis and dose on the x-axis, and plots symbols whose area is proportional to the weights.
}
\examples{
## Summary of raw data from the notorious Neuenschwander et al. (Stat. Med., 2008) trial
## Note the use of the 'cohort' argument to specify the cohort order
neundatTrace = DRtrace(x = c(rep(1:4,each=4), 7, 7, rep(6,9)),
                       y = c(rep(0,16), 1,1, rep(c(0,0,1),2), 0,0,0), 
                       cohort = rep(1:8, c(4,4,4,4, 2, 3,3,3)) )
par(mar=c(3,3,3,1), mgp=c(2,.5,0), tcl=-0.25)
layout(t(1:2))
plot(neundatTrace ,main="N. et al. (2008) Cohort Trace", xlab = 'Cohort', 
          ylab="Ordinal Dose Level" ,cex.main=1.5)

## Same data, in 'doseResponse' format with actual doses rather than dose levels
neundatDose = doseResponse(x=c(1,2.5,5,10,20,25), y = c(rep(0,4),2/9,1), wt = c(3,4,5,4,9,2) )
plot(neundatDose ,main="N. et al. (2008) Final Dose-Toxicity", ylim=c(0,1),
	xlab="Dose (mg/sq.m./wk)", ylab="Toxicity Response Curve (F)", cex.main=1.5)
## We can also convert the DRtrace object to doseResponse...
neundatLevel = doseResponse(neundatTrace)

### Now plotting the former, vs. IR/CIR estimates
neunCIR0 = cirPAVA(neundatDose,full=TRUE, adaptiveShrink = TRUE, target = 0.3)
lines(neunCIR0$shrinkage$x, neunCIR0$shrinkage$y, type='b' ,pch=19)
legend(1,1, pch=c(4,19), legend=c('Observations', 'CIR w/bias corr.'), bty='n')
}
\seealso{
\code{\link{doseResponse}}, \code{\link{DRtrace}}
}
\author{
Assaf P. Oron \code{<assaf.oron.at.gmail.com>}
}
